handlers.GetLeaderboardSizeAndPosition = function (args) {
    var lastPlayerId = "4C63972842DBC90B";
	var leaderboardSize = 0
	var playerPosition = -1
	var responseData = server.GetLeaderboardAroundUser({StatisticName: args.leaderboardId, PlayFabId: lastPlayerId, MaxResultsCount: 1});
	if (responseData.Leaderboard.length > 0)
	{
		leaderboardSize = responseData.Leaderboard[responseData.Leaderboard.length-1].Position;
	}
	else
	{
		server.UpdatePlayerStatistics({PlayFabId: lastPlayerId, Statistics: [{ StatisticName: args.leaderboardId, Value: 0}]}); 
		var secondResponseData = server.GetLeaderboardAroundUser({StatisticName: args.leaderboardId, PlayFabId: lastPlayerId, MaxResultsCount: 1});
		if (secondResponseData.Leaderboard.length > 0)
		{
			leaderboardSize = secondResponseData.Leaderboard[secondResponseData.Leaderboard.length-1].Position;
		}
	}
	var thirdResponseData = server.GetLeaderboardAroundUser({StatisticName: args.leaderboardId, PlayFabId: currentPlayerId, MaxResultsCount: 1});
	if (thirdResponseData.Leaderboard.length > 0)
	{
		playerPosition = thirdResponseData.Leaderboard[thirdResponseData.Leaderboard.length-1].Position;
	}
	log.debug("leaderboardSize: " + leaderboardSize + ", playerPos: " + playerPosition);
	return {leaderboardSize: leaderboardSize, playerPosition: playerPosition};
}

handlers.GetLeaderBoardSize = function (args) {

    var lastPlayerId = "4C63972842DBC90B";
	var responseData = server.GetLeaderboardAroundUser({StatisticName: args.leaderboardId, PlayFabId: lastPlayerId, MaxResultsCount: 1});
	log.debug("1st response status: " + (responseData.Leaderboard.length));
	if (responseData.Leaderboard.length > 0)
	{
		return { leaderboardSize: responseData.Leaderboard[responseData.Leaderboard.length-1].Position };
	}
	else
	{
		server.UpdatePlayerStatistics({PlayFabId: lastPlayerId, Statistics: [{ StatisticName: args.leaderboardId, Value: 0}]}); 
		var secondResponseData = server.GetLeaderboardAroundUser({StatisticName: args.leaderboardId, PlayFabId: lastPlayerId, MaxResultsCount: 1});
		log.debug("2nd response status: " + (secondResponseData.Leaderboard.length > 0 ? "good" : "bad"));
		if (secondResponseData.Leaderboard.length > 0)
		{
			return { leaderboardSize: secondResponseData.Leaderboard[secondResponseData.Leaderboard.length-1].Position };
		}
	}
	log.debug("return default 0");
	return {leaderboardSize: 0};
}

handlers.UpdateLeaderboardScore = function (args) {
	var isHighscore = false;
	if (args.weekend)
	{
		var playerStats = server.GetPlayerStatistics({PlayFabId : currentPlayerId, StatisticNames: [args.leaderboardId]}).Statistics;
		var oldScore = 0
		if (playerStats.length > 0)
			 oldScore = playerStats[0].Value;
		if (args.score > oldScore)
		{
			server.UpdatePlayerStatistics({PlayFabId : currentPlayerId, Statistics: [{StatisticName: args.leaderboardId, Value: args.score}]});
			isHighscore = true;
		}
		return {isHighscore: isHighscore, oldScore: oldScore};
	}
	else
	{
		var attemptKey = "tournamentLevelAttempts_" + args.index;
		var weekdayStats = server.GetUserData({PlayFabId: currentPlayerId, Keys: [args.leaderboardId,attemptKey]}).Data;
		var oldScore = 0;
		if (weekdayStats[args.leaderboardId])
			oldScore = parseInt(weekdayStats[args.leaderboardId].Value);
		if (args.score > oldScore)
		{
			var Data = {};
			Data[args.leaderboardId] = args.score;
			Data[attemptKey] = Math.min(3, weekdayStats[attemptKey].Value+1);
			server.UpdateUserData({PlayFabId: currentPlayerId, Data: Data });
		}
		isHighscore = args.score >= oldScore;
		return {isHighscore: isHighscore, oldScore: oldScore};
	}
}
