/* Created HubInfo tables to match water-db */
CREATE TABLE "HubInfo" (	"ID" INTEGER PRIMARY KEY  NOT NULL  UNIQUE , 
							"Storyline" INTEGER DEFAULT -1, 
							"IAP_item_id" TEXT DEFAULT '', 
							"Bought" BOOL DEFAULT 1, 
							
							"TitleTexture" TEXT DEFAULT '',
							"MainTexture" TEXT DEFAULT '', 
							"FrameTexture" TEXT DEFAULT '', 
							
							"TextColor" TEXT DEFAULT '',
							
							"TextLine1" TEXT DEFAULT '', 
							"TextLine2" TEXT DEFAULT '', 
							
							"DuckCharacter" TEXT DEFAULT '', 
							"ItemCharacter" TEXT DEFAULT '', 
							
							"DuckSQL1" TEXT DEFAULT '',
							"DuckSQL2" TEXT DEFAULT '',
							
							"ItemSQL1" TEXT DEFAULT '',
							"ItemSQL2" TEXT DEFAULT '',
							
							"TextButton" TEXT DEFAULT '',
							
							"AlertText" TEXT DEFAULT ''	, "Unlocked" BOOL DEFAULT 0, DisplayOrder INTEGER NOT NULL DEFAULT 0, DuckyCounterTexture TEXT NOT NULL DEFAULT "");
INSERT INTO "HubInfo" VALUES(0,0,'',1,'WMW_UI_swampy_logo.png','WMW_UI_swampy_empty.png','WMW_UI_portal.png','37 108 138','HUB_TEXT_SWAMPY_TITLE','HUB_TEXT_SWAMPY_BODY','☆','⚀','','','SELECT count(ID) FROM CollectibleInfo WHERE Unlocked=1','SELECT count(ID) FROM CollectibleInfo','PLAY','SWAMPY_NEW_ALERT_OUT_TO_DRY',0,1,'WMW_UI_swampy_duck_counter.png');
INSERT INTO "HubInfo" VALUES(1,1,'crankypack01',0,'WMW_UI_cranky_logo.png','WMW_UI_cranky_empty.png','WMW_UI_portal.png','91 148 43','HUB_TEXT_CRANKY_TITLE','HUB_TEXT_CRANKY_BODY','☠','♨','','','SELECT CASE WHEN count(ID) <= 3 THEN -1 ELSE count(ID) END FROM FoodInfo WHERE Unlocked=1','SELECT count(ID) FROM FoodInfo','PLAY','CRANKY_NEW_ALERT_OVERSTUFFED',0,2,'WMW_UI_cranky_duck_counter.png');
INSERT INTO "HubInfo" VALUES(2,3,'mysteryduck01',0,'WMW_UI_mystery_logo.png','WMW_UI_mystery_empty.png','WMW_UI_portal.png','75 21 13','HUB_TEXT_MYSTERY_TITLE','HUB_TEXT_MYSTERY_BODY','≛','','','','','','PLAY','MYSTERY_NEW_ALERT_LAUNCH',0,4,'WMW_UI_mystery_duck_counter.png');
INSERT INTO "HubInfo" VALUES(3,4,'',1,'','','','','','','','','','','','','','',0,0,'');
INSERT INTO "HubInfo" VALUES(4,5,'',1,'','','','','','','','','','','','','','',0,5,'');
INSERT INTO "HubInfo" VALUES(5,6,'alliepack01',0,'WMW_UI_allie_logo.png','WMW_UI_allie_empty.webp','WMW_UI_portal.png','255 128 50','HUB_TEXT_ALLIE_TITLE','HUB_TEXT_ALLIE_BODY','☥','','','','','','PLAY','ALLIE_NEW_ALERT_LAUNCH',0,3,'WMW_UI_allie_duck_counter.png');


/* Changing level pack info to match lite version */
DROP TABLE LevelPackInfo
CREATE TABLE "LevelPackInfo" ("ID" INTEGER PRIMARY KEY  AUTOINCREMENT  NOT NULL  UNIQUE , "PackName" TEXT NOT NULL  DEFAULT LP_, "Unlocked" BOOL NOT NULL  DEFAULT 0, "HasPlayed" BOOL NOT NULL  DEFAULT 0, "StarsRequired" INTEGER DEFAULT 30, "TileTexture" TEXT NOT NULL  DEFAULT tile_world_01, "LightingColor" TEXT NOT NULL  DEFAULT "255 255 255", "CurtainTexture" TEXT NOT NULL  DEFAULT shower_curtain_01, "LockColor" TEXT NOT NULL  DEFAULT "255 255 255", "HasAlerted" BOOL NOT NULL  DEFAULT 0, "PackType" INTEGER NOT NULL  DEFAULT 0, 'Hidden' BOOL NOT NULL DEFAULT 0, 'PackIcon' TEXT, 'StartDate' DATETIME, 'EndDate' DATETIME, 'Storyline' INTEGER NOT NULL DEFAULT 0, 'IAP_item_id' TEXT NOT NULL DEFAULT '', 'Bought' BOOL NOT NULL DEFAULT 0, 'DuckTextureSuffix' TEXT DEFAULT '', 'FB_AlbumName' TEXT NOT NULL DEFAULT '', 'DisplayPackName' TEXT NOT NULL DEFAULT '', "LS_Unlocked" BOOL DEFAULT 0, GrayType BOOL NOT NULL DEFAULT 0);
INSERT INTO "LevelPackInfo" VALUES(-200,'LP_FEATURED',1,0,0,'tile_world_01','255 255 255','shower_curtain_01','255 255 255',0,0,0,NULL,NULL,NULL,0,'',0,'','','',0,0);
INSERT INTO "LevelPackInfo" VALUES(-101,'LP_SECRET_MYSTERY',0,0,30,'tile_world_01','255 255 255','shower_curtain_01','255 255 255',0,0,0,NULL,NULL,NULL,3,'',0,'','','',0,0);
INSERT INTO "LevelPackInfo" VALUES(-100,'LP_SECRET_CRANKY',0,0,30,'tile_world_01','255 255 255','shower_curtain_01','255 255 255',0,0,0,NULL,NULL,NULL,1,'',0,'','','',0,0);
INSERT INTO "LevelPackInfo" VALUES(-99,'LP_SECRET',0,0,30,'tile_world_01','255 255 255','shower_curtain_01','255 255 255',0,0,0,NULL,NULL,NULL,0,'',0,'','','',0,0);
INSERT INTO "LevelPackInfo" VALUES(-13,'LP_ALLIE_LOTW',1,0,30,'allie_bricks_blue','255 255 255','shower_curtain_01','255 255 255',0,0,0,NULL,NULL,NULL,6,'',0,'','','',0,0);
INSERT INTO "LevelPackInfo" VALUES(-12,'LP_MYSTERY_LOTW',1,0,30,'MD_brick_tile','255 255 255','shower_curtain_01','255 255 255',0,0,0,'world_select_00',NULL,NULL,3,'',0,'','','',0,0);
INSERT INTO "LevelPackInfo" VALUES(-11,'LP_CRANKY_LOTW',1,0,30,'cranky_bricks_purple','255 255 255','shower_curtain_01','255 255 255',0,0,0,'world_select_cranky_00',NULL,NULL,1,'',0,'','Cranky 01 - Crankys First Course','',0,0);
INSERT INTO "LevelPackInfo" VALUES(-10,'LP_SWAMPY_LOTW',1,0,30,'tile_yellow','188 153 71','shower_curtain_01','255 255 255',0,0,0,'world_select_00',NULL,NULL,0,'',0,'','Swampy','',0,0);
INSERT INTO "LevelPackInfo" VALUES(-4,'LP_BONUS_ALLIE',0,0,30,'tile_world_01','255 255 255','shower_curtain_01','255 255 255',0,0,0,NULL,NULL,NULL,6,'alliepack01',0,'','Allie Bonus Levels','',0,0);
INSERT INTO "LevelPackInfo" VALUES(-3,'LP_BONUS_MYSTERY',0,0,30,'tile_world_01','255 255 255','shower_curtain_01','255 255 255',0,0,0,NULL,NULL,NULL,3,'mysteryduck01',0,'','','',0,0);
INSERT INTO "LevelPackInfo" VALUES(-2,'LP_BONUS_CRANKY',0,0,30,'tile_world_01','255 255 255','shower_curtain_01','255 255 255',0,0,0,NULL,NULL,NULL,1,'crankypack01',0,'','Cranky Bonus Levels','',0,0);
INSERT INTO "LevelPackInfo" VALUES(-1,'LP_BONUS',0,0,30,'tile_world_01','255 255 255','shower_curtain_01','255 255 255',0,0,0,NULL,NULL,NULL,0,'',0,'','Swampy Bonus Levels','',0,0);
INSERT INTO "LevelPackInfo" VALUES(10,'LP_ONE',1,0,0,'tile_yellow','188 153 71','shower_curtain_01','255 255 255',0,0,0,'world_select_00',NULL,NULL,0,'',0,'','Swampy 01 - Meet Swampy','',0,0);
INSERT INTO "LevelPackInfo" VALUES(11,'LP_TWO',0,0,25,'tile_purple','193 152 192','shower_curtain_02','102 250 255',0,0,0,'world_select_01',NULL,NULL,0,'',0,'','Swampy 02 - Troubled Waters','',0,0);
INSERT INTO "LevelPackInfo" VALUES(12,'LP_THREE',0,0,65,'tile_green','91 193 165','shower_curtain_03','217 102 255',0,0,0,'world_select_02',NULL,NULL,0,'',0,'','Swampy 03 - Under Pressure','',0,0);
INSERT INTO "LevelPackInfo" VALUES(13,'LP_FOUR',0,0,125,'tile_magenta','192 137 177','shower_curtain_04','181 255 102',0,0,0,'world_select_03',NULL,NULL,0,'',0,'','Swampy 04 - Sink or Swim','',0,0);
INSERT INTO "LevelPackInfo" VALUES(14,'LP_FIVE',0,0,185,'tile_yellow','188 153 71','shower_curtain_01','102 250 255',0,0,0,'world_select_04',NULL,NULL,0,'',0,'','Swampy 05 - Change is Good','',0,0);
INSERT INTO "LevelPackInfo" VALUES(15,'LP_SIX',0,0,245,'tile_purple','193 152 192','shower_curtain_02','217 102 255',0,0,0,'world_select_05',NULL,NULL,0,'',0,'','Swampy 06 - Boiling Point','',0,0);
INSERT INTO "LevelPackInfo" VALUES(16,'LP_SEVEN',0,0,305,'tile_green','91 193 165','shower_curtain_03','181 255 102',0,0,0,'world_select_06',NULL,NULL,0,'',0,'','Swampy 07 - Stretched Thin','',0,0);
INSERT INTO "LevelPackInfo" VALUES(17,'LP_EIGHT',0,0,365,'tile_magenta','192 137 177','shower_curtain_04','102 250 255',0,0,0,'world_select_07',NULL,NULL,0,'',0,'','Swampy 08 - Caution to the Wind','',0,0);
INSERT INTO "LevelPackInfo" VALUES(18,'LP_NINE',0,0,425,'tile_yellow','188 153 71','shower_curtain_01','217 102 255',0,0,0,'world_select_08',NULL,NULL,0,'',0,'','Swampy 09 - Rising Tide','',0,0);
INSERT INTO "LevelPackInfo" VALUES(19,'LP_TEN',0,0,485,'tile_purple','193 152 192','shower_curtain_02','181 255 102',0,0,0,'WMW_world_select_09',NULL,NULL,0,'',0,'','Swampy 10 - Out to Dry','',0,0);
INSERT INTO "LevelPackInfo" VALUES(41,'LP_ONE_MYSTERY',1,0,0,'MD_brick_tile','255 255 255','shower_curtain_01','217 102 255',0,0,0,'world_select_00',NULL,NULL,3,'mysteryduck01',0,'','','LP_ONE',0,0);
INSERT INTO "LevelPackInfo" VALUES(42,'LP_TWO_MYSTERY',0,0,12,'MD_brick_tile','255 255 255','shower_curtain_01','102 250 255',0,3,0,'world_select_01',NULL,NULL,3,'mysteryduck01',0,'','','LP_TWO',0,0);
INSERT INTO "LevelPackInfo" VALUES(43,'LP_THREE_MYSTERY',0,0,30,'MD_brick_tile','255 255 255','shower_curtain_01','217 102 255',0,3,0,'world_select_02',NULL,NULL,3,'mysteryduck01',0,'','','LP_THREE',0,0);
INSERT INTO "LevelPackInfo" VALUES(44,'LP_FOUR_MYSTERY',0,0,45,'MD_brick_tile','255 255 255','shower_curtain_01','181 255 102',0,3,0,'world_select_03',NULL,NULL,3,'mysteryduck01',0,'','','LP_FOUR',0,0);
INSERT INTO "LevelPackInfo" VALUES(45,'LP_FIVE_MYSTERY',0,0,65,'MD_brick_tile','255 255 255','shower_curtain_01','102 250 255',0,3,0,'world_select_04',NULL,NULL,3,'mysteryduck01',0,'','','LP_FIVE',0,0);
INSERT INTO "LevelPackInfo" VALUES(46,'LP_SIX_MYSTERY',0,0,85,'MD_brick_tile','255 255 255','shower_curtain_01','217 102 255',0,3,0,'world_select_05',NULL,NULL,3,'mysteryduck01',0,'','','LP_SIX',0,0);
INSERT INTO "LevelPackInfo" VALUES(47,'LP_SEVEN_MYSTERY',0,0,105,'MD_brick_tile','255 255 255','shower_curtain_01','181 255 102',0,3,0,'world_select_06',NULL,NULL,3,'mysteryduck01',0,'','','LP_SEVEN',0,0);
INSERT INTO "LevelPackInfo" VALUES(48,'LP_EIGHT_MYSTERY',0,0,125,'MD_brick_tile','255 255 255','shower_curtain_01','102 250 255',0,3,0,'world_select_07',NULL,NULL,3,'mysteryduck01',0,'','','LP_EIGHT',0,0);
INSERT INTO "LevelPackInfo" VALUES(49,'LP_NINE_MYSTERY',0,0,145,'MD_brick_tile','255 255 255','shower_curtain_01','217 102 255',0,3,0,'world_select_08',NULL,NULL,3,'mysteryduck01',0,'','','LP_NINE',0,0);
INSERT INTO "LevelPackInfo" VALUES(50,'LP_TEN_MYSTERY',0,0,165,'MD_brick_tile','255 255 255','shower_curtain_01','181 255 102',0,3,0,'WMW_world_select_09',NULL,NULL,3,'mysteryduck01',0,'','','LP_TEN',0,0);
INSERT INTO "LevelPackInfo" VALUES(60,'LP_CRANKY_ONE',1,0,0,'cranky_bricks_purple','255 255 255','shower_curtain_01','255 255 255',0,0,0,'world_select_cranky_00',NULL,NULL,1,'crankypack01',0,'','Cranky 01 - Crankys First Course','',0,0);
INSERT INTO "LevelPackInfo" VALUES(61,'LP_CRANKY_TWO',0,0,25,'cranky_bricks_purple','255 255 255','shower_curtain_01','181 255 102',0,3,0,'world_select_cranky_01',NULL,NULL,1,'crankypack01',0,'','Cranky 02 - Hunger Pains','',0,0);
INSERT INTO "LevelPackInfo" VALUES(62,'LP_CRANKY_THREE',0,0,65,'cranky_bricks_purple','255 255 255','shower_curtain_01','217 102 255',0,3,0,'world_select_cranky_02',NULL,NULL,1,'crankypack01',0,'','Cranky 03 - Bulking Up','',0,0);
INSERT INTO "LevelPackInfo" VALUES(63,'LP_CRANKY_FOUR',0,0,135,'cranky_bricks_purple','255 255 255','shower_curtain_01','181 255 102',0,3,0,'intro_pack_104',NULL,NULL,1,'crankypack01',0,'','Cranky 04 - Overstuffed','',0,0);
INSERT INTO "LevelPackInfo" VALUES(80,'LP_CALENDAR_UNLOCK',1,0,30,'tile_purple','193 152 192','shower_curtain_01_WINTER_2011','255 255 255',0,0,0,'world_select_ten_days_o_swampy',NULL,NULL,2,'',0,'','Lost Levels 01 - 10 Days of Swampy','',0,0);
INSERT INTO "LevelPackInfo" VALUES(81,'LP_HEARTS_AND_CRAFTS',1,0,30,'tile_green','91 193 165','shower_curtain_VALENTINES_2012','255 255 255',0,0,0,'world_select_VALENTINES_2012',NULL,NULL,2,'',0,'','Lost Levels 02 - Hearts and Crafts','',0,0);
INSERT INTO "LevelPackInfo" VALUES(82,'LP_DAYS_OF_SUMMER',1,0,30,'tile_magenta','192 137 177','WMW_UI_LL_summer_curtain','255 255 255',0,0,0,'target_world_select_summer_2012',NULL,NULL,2,'',0,'','Lost Levels 03 - Days of Summer','',0,0);
INSERT INTO "LevelPackInfo" VALUES(83,'LP_ALLIE_ONE',1,0,0,'allie_bricks_blue','255 255 255','shower_curtain_01','255 162 0',0,0,0,'world_select_allie_00',NULL,NULL,6,'alliepack01',0,'','Allie 01 - [REPLACE]','',0,0);
INSERT INTO "LevelPackInfo" VALUES(84,'LP_ALLIE_TWO',0,0,25,'allie_bricks_blue','255 255 255','shower_curtain_01','0 210 255',0,3,0,'world_select_allie_01',NULL,NULL,6,'alliepack01',0,'','Allie 02 - [REPLACE]','',0,0);
INSERT INTO "LevelPackInfo" VALUES(85,'LP_ALLIE_THREE',0,0,65,'allie_bricks_blue','255 255 255','shower_curtain_01','255 162 0',0,3,0,'world_select_allie_02',NULL,NULL,6,'alliepack01',0,'','Allie 03 - [REPLACE]','',0,0);
INSERT INTO "LevelPackInfo" VALUES(86,'LP_ALLIE_FOUR',0,0,135,'allie_bricks_blue','255 255 255','shower_curtain_01','0 210 255',0,3,0,'world_select_allie_03',NULL,NULL,6,'alliepack01',0,'','Allie 04 - [REPLACE]','',0,0);

/* Add level info to DB */
DROP TABLE LevelInfo;
CREATE TABLE "LevelInfo" ("ID" INTEGER PRIMARY KEY  NOT NULL ,"Name" TEXT NOT NULL ,"Filename" TEXT NOT NULL ,"Stars" INTEGER NOT NULL  DEFAULT (0) ,"PackName" TEXT,"TimesPlayed" INTEGER NOT NULL  DEFAULT (0) ,"TimesFinished" INTEGER NOT NULL  DEFAULT (0) ,"Unlocked" BOOL NOT NULL  DEFAULT (0) ,"ParTime" FLOAT NOT NULL  DEFAULT (15.0) ,"BestScore" INTEGER NOT NULL  DEFAULT (0) ,"CollectibleFound" INTEGER NOT NULL  DEFAULT (-1) ,"PlayTime" INTEGER NOT NULL  DEFAULT (0) ,"TimesRetried" INTEGER NOT NULL  DEFAULT (0) ,"IgnoreInStarCount" BOOL NOT NULL  DEFAULT (0) ,"Type" INTEGER DEFAULT (0) ,"StartDate" DATETIME,"EndDate" DATETIME,"Available" BOOL NOT NULL  DEFAULT (1) ,"IsBonus" BOOL NOT NULL  DEFAULT (0) );
INSERT INTO "LevelInfo" VALUES(0,'LN_FIRST_DIG','/Levels/first_dig',0,'LP_ONE',0,0,1,20.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(1,'LN_ROCK_HARD_PLACE','/Levels/rock_is_a_hard_place',0,'LP_ONE',0,0,0,22.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(2,'LN_YELLOW_BRICK_ROAD','/Levels/yellow_brick_road',0,'LP_ONE',0,0,0,23.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3,'LN_JUMP_ON_IT','/Levels/jump_on_it',0,'LP_ONE',0,0,0,19.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(4,'LN_DONT_DILLY_DALLY','/Levels/itll_grow_on_you',0,'LP_ONE',0,0,0,23.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(5,'LN_DEEP_DIG','/Levels/deep_dig',0,'LP_ONE',0,0,0,32.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(6,'LN_DRAIN_IT_FIRST','/Levels/drain_it_first',0,'LP_ONE',0,0,0,33.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(7,'LN_DIRTY_WATER','/Levels/dirty_water_and_algae',0,'LP_ONE',0,0,0,48.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(8,'LN_MAKE_MORE_DIRTY','/Levels/make_more_dirty_water',0,'LP_ONE',0,0,0,43.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(9,'LN_SPLIT_DECISION','/Levels/split_decision_numero_dos',0,'LP_ONE',0,0,0,63.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(10,'LN_DIVERT','/Levels/divert',0,'LP_ONE',0,0,0,23.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(11,'LN_FIRST_SWITCH','/Levels/first_switch',0,'LP_ONE',0,0,0,27.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(12,'LN_SWITCH_FALL','/Levels/switch_fall',0,'LP_ONE',0,0,0,60.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(13,'LN_LOOP_THE_LOOP','/Levels/loop_redux',0,'LP_ONE',0,0,0,58.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(14,'LN_MOTOR_TEST','/Levels/motor_test',0,'LP_ONE',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(15,'LN_FLINGING_HORSESHOES','/Levels/flinging_horseshoes',0,'LP_ONE',0,0,0,33.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(16,'LN_OFF_TRACK','/Levels/off_track',0,'LP_ONE',0,0,0,32.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(17,'LN_SWITCH_OFF_GRASS','/Levels/switch_off_the_grass',0,'LP_ONE',0,0,0,34.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(18,'LN_SEESAW','/Levels/seesaw',0,'LP_ONE',0,0,0,31.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(19,'LN_TARRED_FEATHERED','/Levels/tarred_and_feathered',0,'LP_ONE',0,0,0,33.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(20,'LN_TAKE_ME_HIGHER','/Levels/can_you_take_me_higher',0,'LP_TWO',0,0,1,43.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(21,'LN_SMASH_THEM_TOGETHER','/Levels/smash_them_together',0,'LP_TWO',0,0,0,20.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(22,'LN_INTO_THE_CAVE','/Levels/into_the_cave',0,'LP_TWO',0,0,0,28.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(23,'LN_LONG_JOURNEY','/Levels/long_journey',0,'LP_TWO',0,0,0,40.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(24,'LN_THERE_AND_BACK','/Levels/there_and_back_again',0,'LP_TWO',0,0,0,40.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(25,'LN_HURRY','/Levels/hurry',0,'LP_TWO',0,0,0,20.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(26,'LN_WHAT_GOES_UP','/Levels/what_goes_up',0,'LP_TWO',0,0,0,23.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(27,'LN_ONE_STREAM','/Levels/one_stream',0,'LP_TWO',0,0,0,40.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(28,'LN_ONE_STEP_AT_TIME','/Levels/one_step_at_a_time',0,'LP_TWO',0,0,0,36.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(29,'LN_MAKE_WAVE','/Levels/make_a_wave',0,'LP_TWO',0,0,0,36.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(30,'LN_REPTILES_PLUMBERS','/Levels/reptiles_and_plumbers',0,'LP_TWO',0,0,0,28.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(31,'LN_BUNKER','/Levels/bunker',0,'LP_TWO',0,0,0,25.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(32,'LN_LEVEL_IT_OUT','/Levels/level_it_out',0,'LP_TWO',0,0,0,35.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(33,'LN_MIND_THE_GAP','/Levels/mind_the_gap',0,'LP_TWO',0,0,0,55.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(34,'LN_DANTES_WIDOWS_PEAK','/Levels/dantes_widows_peak',0,'LP_TWO',0,0,0,35.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(35,'LN_CATCH_IF_YOU_CAN','/Levels/catch_me_if_you_can',0,'LP_TWO',0,0,0,48.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(36,'LN_CONVERSION','/Levels/conversion',0,'LP_TWO',0,0,0,53.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(37,'LN_SLUDGE_THE_DESTROYER','/Levels/sludge_the_destroyer',0,'LP_TWO',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(38,'LN_ORBIT','/Levels/orbit',0,'LP_TWO',0,0,0,49.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(39,'LN_HALF_HALF','/Levels/half_and_half',0,'LP_TWO',0,0,0,66.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(40,'LN_MINE_FIELD','/Levels/mine_field',0,'LP_THREE',0,0,1,40.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(41,'LN_AROUND_THE_BOMB','/Levels/around_the_bomb',0,'LP_THREE',0,0,0,32.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(42,'LN_LAVA_TIMING','/Levels/lava_timing',0,'LP_THREE',0,0,0,38.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(43,'LN_MULTITOUCH','/Levels/multitouch',0,'LP_THREE',0,0,0,33.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(44,'LN_BOMB_CHAIN','/Levels/bomb_chain',0,'LP_THREE',0,0,0,28.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(45,'LN_CROSSING_RIVER','/Levels/crossing_the_river',0,'LP_THREE',0,0,0,100.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(46,'LN_FROM_ON_HIGH','/Levels/from_on_high',0,'LP_THREE',0,0,0,33.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(47,'LN_LETS_PLAY_CATCH','/Levels/lets_play_catch',0,'LP_THREE',0,0,0,53.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(48,'LN_FIRST_MOMENTARY','/Levels/first_momentary',0,'LP_THREE',0,0,0,49.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(49,'LN_LAVA_RIVER','/Levels/lava_river',0,'LP_THREE',0,0,0,37.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(50,'LN_RAT_IN_A_MAZE','/Levels/rat_in_a_maze',0,'LP_THREE',0,0,0,90.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(51,'LN_BOMB_IT_UP','/Levels/bomb_it_up',0,'LP_THREE',0,0,0,69.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(52,'LN_REDIRECTION','/Levels/redirection',0,'LP_THREE',0,0,0,63.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(53,'LN_BLOW_THE_ROOF_OFF','/Levels/blow_the_roof_off',0,'LP_THREE',0,0,0,45.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(54,'LN_GOING_DOWN','/Levels/going_down',0,'LP_THREE',0,0,0,58.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(55,'LN_TEMPLE_TACTICS','/Levels/temple_tactics',0,'LP_THREE',0,0,0,63.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(56,'LN_EROSION','/Levels/erosion',0,'LP_THREE',0,0,0,63.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(57,'LN_UNTIMELY_GROWTH','/Levels/untimely_growth',0,'LP_THREE',0,0,0,41.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(58,'LN_WATER_PINBALL','/Levels/water_pinball',0,'LP_THREE',0,0,0,39.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(59,'LN_AQUA_PORTALS','/Levels/aqua_portals',0,'LP_THREE',0,0,0,68.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(60,'LN_LOGIC_GATES','/Levels/logic_gates',0,'LP_FOUR',0,0,1,32.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(61,'LN_MOMENTUM_101','/Levels/momentum_101',0,'LP_FOUR',0,0,0,29.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(62,'LN_PIPING','/Levels/piping',0,'LP_FOUR',0,0,0,56.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(63,'LN_BRIDGE_BUILDER','/Levels/bridge_builder',0,'LP_FOUR',0,0,0,65.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(64,'LN_FLING_SHOT','/Levels/fling_shot',0,'LP_FOUR',0,0,0,70.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(65,'LN_DADDY_WATERBUCKS','/Levels/daddy_waterbucks',0,'LP_FOUR',0,0,0,46.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(66,'LN_SQUEEZE_MY_WATER','/Levels/squeeze_my_water',0,'LP_FOUR',0,0,0,80.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(67,'LN_NICE_CLOGS','/Levels/nice_clogs',0,'LP_FOUR',0,0,0,40.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(68,'LN_CURSE_OF_THE_ALGAE','/Levels/curse_of_the_algae_beard',0,'LP_FOUR',0,0,0,46.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(69,'LN_SLIDERS','/Levels/sliders',0,'LP_FOUR',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(70,'LN_THEYVE_GOT_CHEMISTRY','/Levels/theyve_got_chemistry',0,'LP_FOUR',0,0,0,40.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(71,'LN_MODE_B','/Levels/if_you_build_it_they_will_come',0,'LP_FOUR',0,0,0,60.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(72,'LN_DEATH_BLOSSOM','/Levels/death_blossom',0,'LP_FOUR',0,0,0,57.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(73,'LN_RHYTHM_NIRVANA','/Levels/rhythm_nirvana',0,'LP_FOUR',0,0,0,100.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(74,'LN_FIGURE_EIGHT','/Levels/figure_8',0,'LP_FOUR',0,0,0,55.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(75,'LN_CREATE_DESTROY','/Levels/force_field',0,'LP_FOUR',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(76,'LN_THE_GRID','/Levels/the_grid',0,'LP_FOUR',0,0,0,55.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(77,'LN_ANOTHER_CASTLE','/Levels/another_castle',0,'LP_FOUR',0,0,0,42.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(78,'LN_DANGEROUS_SLOPE','/Levels/dangerous_slope',0,'LP_FOUR',0,0,0,100.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(79,'LN_RINSE_CYCLE','/Levels/rinse_cycle',0,'LP_FOUR',0,0,0,140.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(80,'LN_HOURGLASS','/Levels/hourglass',0,'LP_BONUS',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,1);
INSERT INTO "LevelInfo" VALUES(81,'LN_BONUS_TEST','/Levels/bonus_test',0,'LP_BONUS',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,1);
INSERT INTO "LevelInfo" VALUES(82,'LN_THE_MAZE','/Levels/bonus_maze',0,'LP_BONUS',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,1);
INSERT INTO "LevelInfo" VALUES(83,'LN_GOLDEN_RATIO','/Levels/golden_ratio',0,'LP_BONUS',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,1);
INSERT INTO "LevelInfo" VALUES(84,'LN_BOMB_BONUS','/Levels/bomb_bonus',0,'LP_BONUS',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,1);
INSERT INTO "LevelInfo" VALUES(85,'LN_ALGAE_CIRCLE','/Levels/algae_circle',0,'LP_BONUS',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,1);
INSERT INTO "LevelInfo" VALUES(86,'LN_BUILD_TILT','/Levels/build_and_tilt',0,'LP_BONUS',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,1);
INSERT INTO "LevelInfo" VALUES(87,'LN_BEEHIVE','/Levels/beehive',0,'LP_BONUS',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,1);
INSERT INTO "LevelInfo" VALUES(88,'LN_ONION_PEEL','/Levels/onion_peel',0,'LP_BONUS',0,0,0,40.0,0,-1,0,0,0,0,NULL,NULL,1,1);
INSERT INTO "LevelInfo" VALUES(89,'LN_NEVER_LET_YOU_GO','/Levels/never_let_you_go',0,'LP_BONUS',0,0,0,40.0,0,-1,0,0,0,0,NULL,NULL,1,1);
INSERT INTO "LevelInfo" VALUES(90,'LN_STEAM_IT_UP','/Levels/steam_it_up',0,'LP_BONUS',0,0,0,40.0,0,-1,0,0,0,0,NULL,NULL,1,1);
INSERT INTO "LevelInfo" VALUES(91,'LN_AROUND_THE_BLOCK','/Levels/around_the_block',0,'LP_BONUS',0,0,0,40.0,0,-1,0,0,0,0,NULL,NULL,1,1);
INSERT INTO "LevelInfo" VALUES(92,'LN_BALLOON_MAZE','/Levels/balloon_bonus_2',0,'LP_BONUS',0,0,0,40.0,0,-1,0,0,0,0,NULL,NULL,1,1);
INSERT INTO "LevelInfo" VALUES(93,'LN_TILT_WITH_CAUTION','/Levels/boom_boom',0,'LP_BONUS',0,0,0,40.0,0,-1,0,0,0,0,NULL,NULL,1,1);
INSERT INTO "LevelInfo" VALUES(94,'LN_SPRING_CLEANING','/Levels/spring_cleaning',0,'LP_BONUS',0,0,0,40.0,0,-1,0,0,0,0,NULL,NULL,1,1);
INSERT INTO "LevelInfo" VALUES(95,'LN_AIR_MAZE','/Levels/Mini_G_Dynamo',0,'LP_BONUS',0,0,0,40.0,0,-1,0,0,0,0,NULL,NULL,1,1);
INSERT INTO "LevelInfo" VALUES(96,'LN_DONUTS','/Levels/donuts',0,'LP_BONUS',0,0,0,40.0,0,-1,0,0,0,0,NULL,NULL,1,1);
INSERT INTO "LevelInfo" VALUES(97,'LN_TWO_WAY_STREAMS','/Levels/Y-No-Bonus',0,'LP_BONUS',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,1);
INSERT INTO "LevelInfo" VALUES(98,'LN_FULL_OF_MUD','/Levels/b1_full_of_mud',0,'LP_BONUS',0,0,0,100.0,0,-1,0,0,0,0,NULL,NULL,1,1);
INSERT INTO "LevelInfo" VALUES(99,'LN_FAST_STREAM','/Levels/b2_dirt_divert',0,'LP_BONUS',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,1);
INSERT INTO "LevelInfo" VALUES(100,'LN_JC3','/Levels/jc3',0,'LP_SECRET',0,0,0,50.0,0,-1,0,0,1,0,NULL,NULL,1,1);
INSERT INTO "LevelInfo" VALUES(101,'LN_CONVERTER_INTRO','/Levels/converter_intro',0,'LP_FIVE',0,0,1,30.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(102,'LN_RECYCLING_WORKS','/Levels/recycling_works',0,'LP_FIVE',0,0,0,35.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(103,'LN_OUCH_MY_EYE','/Levels/ouch_my_eye',0,'LP_FIVE',0,0,0,35.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(104,'LN_CONVERSION_TEST','/Levels/test_tube_redux',0,'LP_FIVE',0,0,0,45.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(105,'LN_CONVERTER_JOURNEY','/Levels/converter_journey',0,'LP_FIVE',0,0,0,40.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(106,'LN_CLEAR_AND_SHOOT','/Levels/clear_and_shoot',0,'LP_FIVE',0,0,0,55.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(107,'LN_DOUBLE_LAUNCH_REDUX','/Levels/double_launch_redux',0,'LP_FIVE',0,0,0,45.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(108,'LN_UNDERCURRENT','/Levels/undercurrent',0,'LP_FIVE',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(109,'LN_MULTI_CONVERT','/Levels/multi_convert',0,'LP_FIVE',0,0,0,40.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(110,'LN_MINER','/Levels/miner',0,'LP_FIVE',0,0,0,70.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(111,'LN_CATCH_THEM_ALL','/Levels/catch_them_all',0,'LP_FIVE',0,0,0,45.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(112,'LN_SCAFFOLDING','/Levels/scaffolding',0,'LP_FIVE',0,0,0,35.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(113,'LN_GET_ON_THE_TRAIN','/Levels/get_on_the_train',0,'LP_FIVE',0,0,0,55.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(114,'LN_DOUBLE_DIPPING','/Levels/double_dipping',0,'LP_FIVE',0,0,0,45.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(115,'LN_CONVERTER_GATE','/Levels/converter_gate',0,'LP_FIVE',0,0,0,60.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(116,'LN_OOZE_IS_ALRIGHT','/Levels/ooze_is_alright',0,'LP_FIVE',0,0,0,35.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(117,'LN_PICK_YOUR_POISON','/Levels/pick_your_poison',0,'LP_FIVE',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(118,'LN_ACROSS_THE_BRIDGE','/Levels/across_the_bridge',0,'LP_FIVE',0,0,0,60.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(119,'LN_THE_POT_BOILS_OVER','/Levels/the_pot_boils_over',0,'LP_FIVE',0,0,0,45.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(120,'LN_HOOKSHOT_HEAVEN','/Levels/hookshot_heaven',0,'LP_FIVE',0,0,0,60.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(121,'LN_STEAM_INTRO','/Levels/steam_intro',0,'LP_SIX',0,0,1,25.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(122,'LN_RECYCLER','/Levels/recycler',0,'LP_SIX',0,0,0,40.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(123,'LN_CEILING_CATCHER','/Levels/ceiling_catcher',0,'LP_SIX',0,0,0,40.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(124,'LN_RISE_AND_FALL','/Levels/rise_and_fall',0,'LP_SIX',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(125,'LN_A_CLEANER_APPROACH','/Levels/a_cleaner_approach',0,'LP_SIX',0,0,0,55.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(126,'LN_CATCH_AND_RELEASE','/Levels/catch_and_release',0,'LP_SIX',0,0,0,75.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(127,'LN_SEPARATE_WAYS','/Levels/separate_ways',0,'LP_SIX',0,0,0,80.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(128,'LN_THROUGH_THE_BRIDGE','/Levels/through_the_bridge',0,'LP_SIX',0,0,0,45.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(129,'LN_OL_SWITCHEROO','/Levels/ol_switcheroo',0,'LP_SIX',0,0,0,55.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(130,'LN_BELOW_THE_BBQ','/Levels/below_the_bbq',0,'LP_SIX',0,0,0,40.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(131,'LN_A_RACE_TO_THE_FINISH','/Levels/a_race_to_the_finish',0,'LP_SIX',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(132,'LN_REVOLVING_DOOR','/Levels/revolving_door',0,'LP_SIX',0,0,0,55.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(133,'LN_RACE_THE_OOZE','/Levels/race_the_ooze',0,'LP_SIX',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(134,'LN_STEAM_BOT','/Levels/steam_bot',0,'LP_SIX',0,0,0,75.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(135,'LN_VENTILATION_SHAFT','/Levels/ventilation_shaft',0,'LP_SIX',0,0,0,55.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(136,'LN_STEAM_QUARANTENE','/Levels/steam_quarantene',0,'LP_SIX',0,0,0,45.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(137,'LN_JUMPING_GIGAWATTS','/Levels/jumping_gigawatts',0,'LP_SIX',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(138,'LN_TRAP_DOOR','/Levels/trap_door',0,'LP_SIX',0,0,0,45.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(139,'LN_UP_AND_DOWN','/Levels/up_and_down',0,'LP_SIX',0,0,0,65.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(140,'LN_STEAM_JOURNEY','/Levels/time_to_split',0,'LP_SIX',0,0,0,120.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(141,'LN_BALLOON_INTRO','/Levels/balloon_intro',0,'LP_SEVEN',0,0,1,35.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(142,'LN_BURST_YOUR_BUBBLE','/Levels/2_pop',0,'LP_SEVEN',0,0,0,40.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(143,'LN_GEYSER','/Levels/geiser',0,'LP_SEVEN',0,0,0,39.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(144,'LN_BALLOON_BRIDGE','/Levels/balloon_bridge',0,'LP_SEVEN',0,0,0,38.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(145,'LN_JAGGED_EDGE','/Levels/jagged_edge',0,'LP_SEVEN',0,0,0,43.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(146,'LN_YOU_SHALL_NOT_PASS','/Levels/you_shall_not_pass',0,'LP_SEVEN',0,0,0,43.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(147,'LN_TRUST_FALL','/Levels/firin_mah_lazer',0,'LP_SEVEN',0,0,0,44.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(148,'LN_DROP_BY_DROP','/Levels/drop_by_drop',0,'LP_SEVEN',0,0,0,41.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(149,'LN_BALLOON_CATAPULT','/Levels/balloon_catapult',0,'LP_SEVEN',0,0,0,49.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(150,'LN_MIRROR_IMAGE','/Levels/mirror_image',0,'LP_SEVEN',0,0,0,38.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(151,'LN_DRAIN_AND_DROP','/Levels/drain_and_drop',0,'LP_SEVEN',0,0,0,45.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(152,'LN_HOT_AIR_BALLOON','/Levels/hot_air_balloon',0,'LP_SEVEN',0,0,0,40.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(153,'LN_PINBALL','/Levels/balloon_pinball',0,'LP_SEVEN',0,0,0,60.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(154,'LN_BALLOON_FOUNTAIN','/Levels/balloon_fountain',0,'LP_SEVEN',0,0,0,55.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(155,'LN_BALLOON_JOURNEY','/Levels/current_pool',0,'LP_SEVEN',0,0,0,53.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(156,'LN_PURER_PATHS_PREVAIL','/Levels/purer_paths_prevail',0,'LP_SEVEN',0,0,0,43.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(157,'LN_PLATFORMER','/Levels/new_platformer',0,'LP_SEVEN',0,0,0,57.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(158,'LN_BOOBY_TRAP_STAIRCASE','/Levels/booby_trap_staircase',0,'LP_SEVEN',0,0,0,71.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(159,'LN_PUSH_POP','/Levels/push_pop',0,'LP_SEVEN',0,0,0,51.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(160,'LN_ROLL_YOUR_OWN_POISON','/Levels/roll_your_own_poison',0,'LP_SEVEN',0,0,0,75.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(161,'LN_FIRST_FAN','/Levels/first_fan',0,'LP_EIGHT',0,0,1,25.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(162,'LN_FAN_INTRO','/Levels/fan_intro',0,'LP_EIGHT',0,0,0,30.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(163,'LN_UPDRAFT','/Levels/updraft',0,'LP_EIGHT',0,0,0,30.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(164,'LN_OVERLAP','/Levels/overlap',0,'LP_EIGHT',0,0,0,40.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(165,'LN_ON_AND_OFF','/Levels/on_and_off',0,'LP_EIGHT',0,0,0,35.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(166,'LN_VACUUM_TUTORIAL','/Levels/Vacuum_Tutorial',0,'LP_EIGHT',0,0,0,40.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(167,'LN_VOID','/Levels/void',0,'LP_EIGHT',0,0,0,40.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(168,'LN_PULL_UP','/Levels/dirty_fan',0,'LP_EIGHT',0,0,0,40.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(169,'LN_OCCULSION_TUTORIAL','/Levels/occlude_tutorial',0,'LP_EIGHT',0,0,0,30.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(170,'LN_MAKE_UP_YOUR_MIND','/Levels/flip_flop',0,'LP_EIGHT',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(171,'LN_FREEFALLIN','/Levels/freefallin',0,'LP_EIGHT',0,0,0,35.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(172,'LN_VACUUM_BRIDGE','/Levels/Vacuum_Bridge',0,'LP_EIGHT',0,0,0,70.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(173,'LN_ALL_YOUR_DUCKS','/Levels/fan_divert',0,'LP_EIGHT',0,0,0,60.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(174,'LN_ICE_PIT','/Levels/ice_pit',0,'LP_EIGHT',0,0,0,90.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(175,'LN_WATER_WORLD','/Levels/waterworld',0,'LP_EIGHT',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(176,'LN_PULL_ME_UP','/Levels/pass_the_balloon',0,'LP_EIGHT',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(177,'LN_EVIL_FAN','/Levels/evil_fan',0,'LP_EIGHT',0,0,0,70.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(178,'LN_FAN_CLEANER','/Levels/mid_air_mix',0,'LP_EIGHT',0,0,0,40.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(179,'LN_WIND_SLOOPER','/Levels/wind_slooper',0,'LP_EIGHT',0,0,0,55.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(180,'LN_GRAVITY_DYNAMO','/Levels/gravity_dynamo',0,'LP_EIGHT',0,0,0,100.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(181,'LN_CHANGE_DIRECTION','/Levels/change_directions',0,'LP_NINE',0,0,1,35.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(182,'LN_MIX_IT_UP','/Levels/hydrospheres',0,'LP_NINE',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(183,'LN_ALTERNATING_CURRENTS','/Levels/switch_it_up',0,'LP_NINE',0,0,0,75.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(184,'LN_ONE_SHOT_WONDER','/Levels/one_in_the_barrel',0,'LP_NINE',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(185,'LN_CONJUNCTION_JUNCTION','/Levels/FlippingSwitches',0,'LP_NINE',0,0,0,70.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(186,'LN_HALF_AND_HALF_TWO','/Levels/spread_the_wealth',0,'LP_NINE',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(187,'LN_CROSSING_GUARD','/Levels/pass_the_peas',0,'LP_NINE',0,0,0,60.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(188,'LN_STOPPED_UP','/Levels/stoppit',0,'LP_NINE',0,0,0,45.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(189,'LN_STOP_AND_DROP','/Levels/plop',0,'LP_NINE',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(190,'LN_KEEP_IT_UP','/Levels/keep_it_up',0,'LP_NINE',0,0,0,60.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(191,'LN_RAINMAKER','/Levels/rainmaker',0,'LP_NINE',0,0,0,55.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(192,'LN_HALF_EMPTY','/Levels/flooded_shooting',0,'LP_NINE',0,0,0,60.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(193,'LN_OCTOSPOUT','/Levels/octospout',0,'LP_NINE',0,0,0,75.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(194,'LN_EXPLODING_ELEVATOR','/Levels/all_is_needed',0,'LP_NINE',0,0,0,75.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(195,'LN_TRI_CYCLE','/Levels/controlled_thought-JOSE',0,'LP_NINE',0,0,0,100.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(196,'LN_STEAM_SPLITTER','/Levels/steam_splitter',0,'LP_NINE',0,0,0,70.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(197,'LN_OOZEPOCALYPSE','/Levels/oozepocalypse2012',0,'LP_NINE',0,0,0,30.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(198,'LN_LEVITATING_LIQUIDS','/Levels/juggling',0,'LP_NINE',0,0,0,90.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(199,'LN_OOZE_IT_OR_LOSE_IT','/Levels/need_all_of_it',0,'LP_NINE',0,0,0,70.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(200,'LN_FULL_OF_HOT_AIR','/Levels/valve_playground',0,'LP_NINE',0,0,0,180.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(201,'LN_FIRST_MUD_ALSO','/Levels/01_let_it_dry',0,'LP_TEN',0,0,1,40.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(202,'LN_WALL_AND_ALGAE','/Levels/02_muddy_floor',0,'LP_TEN',0,0,0,45.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(203,'LN_DRY_ME','/Levels/03_cut_and_dry',0,'LP_TEN',0,0,0,55.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(204,'LN_WALL_ON_THE_SPOT','/Levels/04_plug_the_hole',0,'LP_TEN',0,0,0,45.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(205,'LN_SLOW_IT_DOWN','/Levels/05_bog_it_down',0,'LP_TEN',0,0,0,40.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(206,'LN_MUDDY_JOURNEY','/Levels/06_muddy_journey',0,'LP_TEN',0,0,0,60.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(207,'LN_ODDWALLS','/Levels/07_spots_on_the_wall',0,'LP_TEN',0,0,0,75.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(208,'LN_CAN_YOU_DIG_IT','/Levels/08_can_you_dig_it',0,'LP_TEN',0,0,0,85.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(209,'LN_DOUBLE_DECKER_BRIDGE','/Levels/09_double_decker_bridge',0,'LP_TEN',0,0,0,55.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(210,'LN_DRAINCLOG','/Levels/10_walls_of_mud',0,'LP_TEN',0,0,0,45.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(211,'LN_MUD_TOWERS','/Levels/11_mud_bucket',0,'LP_TEN',0,0,0,75.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(212,'LN_SLOOP_DU_JOUR','/Levels/12_make_a_ramp',0,'LP_TEN',0,0,0,75.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(213,'LN_WET_DRY','/Levels/13_subdivision',0,'LP_TEN',0,0,0,70.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(214,'LN_READY_POSITION','/Levels/14_misty_mud',0,'LP_TEN',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(215,'LN_MUD_SLOOP','/Levels/15_redo',0,'LP_TEN',0,0,0,65.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(216,'LN_FILL_THE_COLUMS','/Levels/16_fill_columns',0,'LP_TEN',0,0,0,100.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(217,'LN_LANDFILL','/Levels/17_landfill',0,'LP_TEN',0,0,0,110.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(218,'LN_MUD_BOX','/Levels/18_bucket_builder',0,'LP_TEN',0,0,0,100.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(219,'LN_SPA_TREATMENT','/Levels/19_spa_treatment',0,'LP_TEN',0,0,0,70.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(220,'LN_MUD_BRIDGE','/Levels/20_dry_landing',0,'LP_TEN',0,0,0,60.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(1000,'LN_FISTFUL_OF_NOTHING','/Levels/fist_full_of_nothing',0,'LP_SECRET',0,0,0,40.0,0,-1,0,0,1,0,NULL,NULL,1,1);
INSERT INTO "LevelInfo" VALUES(1001,'LN_CHEAT_CODE','/Levels/super_c',0,'LP_SECRET',0,0,0,40.0,0,-1,0,0,1,0,NULL,NULL,1,1);
INSERT INTO "LevelInfo" VALUES(1002,'LN_PLANETS','/Levels/planets',0,'LP_SECRET',0,0,0,40.0,0,-1,0,0,1,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(1003,'LN_MINING_LASER','/Levels/mining_lazer',0,'LP_SECRET_CRANKY',0,0,0,100.0,0,-1,0,0,1,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(1004,'LN_LOADING_SCREEN','/Levels/loading_screen',0,'LP_SECRET',0,0,0,90.0,0,-1,0,0,1,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(1005,'LN_UPS_AND_DOWNS','/Levels/UPS_AND_DOWNS',0,'LP_SECRET',0,0,0,60.0,0,-1,0,0,1,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(1006,'LN_GOOD_MORNING','/Levels/LN_GOOD_MORNING',0,'LP_SECRET',0,0,0,30.0,0,-1,0,0,1,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(1007,'LN_SARAS_LEVEL','/Levels/S3_SARAS_LEVEL',0,'LP_SECRET_CRANKY',0,0,0,30.0,0,-1,0,0,1,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(1008,'LN_MI_AMORE','/Levels/mi_amore',0,'LP_SECRET',0,0,0,90.0,0,-1,0,0,1,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(1009,'LN_MAKE_A_WISH','/Levels/make_a_wish',0,'LP_SECRET',0,0,0,44.0,0,-1,0,0,1,2,'2012-09-15 00:00:00','2012-09-29 00:00:00',1,0);
INSERT INTO "LevelInfo" VALUES(1010,'LN_SECRET_AGENTP','/Levels/agent_p',0,'LP_SECRET',0,0,0,55.0,0,-1,0,0,1,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(1011,'MYSTERIOUS_PLANETS_LBL','/Levels/planets',0,'LP_SECRET_MYSTERY',0,0,0,15.0,0,-1,0,0,1,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(1012,'LN_FIRE_EXTINGUISHER','/Levels/fire_extinguisher',0,'LP_SECRET',0,0,0,70.0,0,-1,0,0,1,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(2000,'LN_SECOND_DIG','/Levels/second_dig',0,'LP_CRANKY_ONE',0,0,1,15.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(2001,'LN_MEET_ME_IN_THE_MIDDLE','/Levels/meet_me_in_the_middle',0,'LP_CRANKY_ONE',0,0,0,35.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(2002,'LN_PURPLE_RAIN','/Levels/waterfall',0,'LP_CRANKY_ONE',0,0,0,37.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(2003,'LN_LAWN_SPRINKLER','/Levels/lawn_sprinkler',0,'LP_CRANKY_ONE',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(2004,'LN_AROUND_THE_WORLD','/Levels/around_the_world',0,'LP_CRANKY_ONE',0,0,0,65.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(2005,'LN_BRIDGE_OVER','/Levels/alignment_issues',0,'LP_CRANKY_ONE',0,0,0,45.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2006,'LN_VALVE_THE_PRESS','/Levels/valve_the_press',0,'LP_CRANKY_ONE',0,0,0,40.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2007,'LN_SPLIT_ENDS','/Levels/hold_it_right_there',0,'LP_CRANKY_ONE',0,0,0,45.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2008,'LN_SWIRLY_BOMB','/Levels/BHVR_swirlie_bomb',0,'LP_CRANKY_ONE',0,0,0,35.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2009,'LN_SLIDESHOW','/Levels/BHVR_machine_room',0,'LP_CRANKY_ONE',0,0,0,42.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2010,'LN_BOOMSTICK','/Levels/boomstick',0,'LP_CRANKY_ONE',0,0,0,45.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2011,'LN_CONNECT_THE_DOTS','/Levels/BHVR_drain_match',0,'LP_CRANKY_ONE',0,0,0,35.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2012,'LN_FOUNDRY','/Levels/BHVR_the_foundry',0,'LP_CRANKY_ONE',0,0,0,66.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2013,'LN_BRIDGE_BREAKER','/Levels/bridge_breaker',0,'LP_CRANKY_ONE',0,0,0,75.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2014,'LN_POISON_DODGE','/Levels/poison_dodge',0,'LP_CRANKY_ONE',0,0,0,70.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2015,'LN_DUCK_INVADERS','/Levels/duck_invaders',0,'LP_CRANKY_ONE',0,0,0,40.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2016,'LN_MUST_COME_DOWN','/Levels/must_come_down',0,'LP_CRANKY_ONE',0,0,0,35.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2017,'LN_ORDER_POOL','/Levels/order_pool',0,'LP_CRANKY_ONE',0,0,0,34.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2018,'LN_WATER_BOMB_DODGER','/Levels/BHVR_water_bomb_dodger',0,'LP_CRANKY_ONE',0,0,0,38.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2019,'LN_POLLUTON_SOLUTION','/Levels/CR_pollution',0,'LP_CRANKY_ONE',0,0,0,58.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2020,'LN_DOWN_THE_STAIRS','/Levels/stream_grind',0,'LP_CRANKY_TWO',0,0,1,35.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2021,'LN_STEAM_BOMB_DODGER','/Levels/BHVR_steam_bomb_dodger',0,'LP_CRANKY_TWO',0,0,0,42.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2022,'LN_RECYCLE','/Levels/reuser',0,'LP_CRANKY_TWO',0,0,0,44.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2023,'LN_CONVERT_EM','/Levels/BHVR_dirt_it_out',0,'LP_CRANKY_TWO',0,0,0,55.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2024,'LN_REGROUP','/Levels/regroup',0,'LP_CRANKY_TWO',0,0,0,45.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2025,'LN_UNDER_PRESSURE','/Levels/CR_levitation',0,'LP_CRANKY_TWO',0,0,0,115.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2026,'LN_MOSSY_PATH','/Levels/BHVR_mossy_path',0,'LP_CRANKY_TWO',0,0,0,35.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2027,'LN_VALVE_CONTROL','/Levels/BHVR_valve_control',0,'LP_CRANKY_TWO',0,0,0,60.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2028,'LN_MID_AIR_COLLISION','/Levels/mid_air_collision',0,'LP_CRANKY_TWO',0,0,0,40.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2029,'LN_RECONTAMINATION','/Levels/CR_recontamination',0,'LP_CRANKY_TWO',0,0,0,55.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2030,'LN_VOLCANO','/Levels/volcano',0,'LP_CRANKY_TWO',0,0,0,40.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2031,'LN_STEAM_SCULPTER','/Levels/BHVR_steam_sculptor',0,'LP_CRANKY_TWO',0,0,0,35.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2032,'LN_OOZE_STOPPER','/Levels/ooze_stopper',0,'LP_CRANKY_TWO',0,0,0,45.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2033,'LN_VICIOUS_CYCLE','/Levels/CR_vicious_cycle',0,'LP_CRANKY_TWO',0,0,0,60.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2034,'LN_PIPE_CLEANER','/Levels/CR_pipe_cleaner',0,'LP_CRANKY_TWO',0,0,0,70.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2035,'LN_WORTHLESS_WATER','/Levels/CR_worthless_water',0,'LP_CRANKY_TWO',0,0,0,40.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2036,'LN_FUSION_GRIND','/Levels/BHVR_fusion_grind',0,'LP_CRANKY_TWO',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2037,'LN_LAYER_CAKE','/Levels/layer_cake',0,'LP_CRANKY_TWO',0,0,0,42.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2038,'LN_AQUA_TOOL','/Levels/CR_aqua_tool',0,'LP_CRANKY_TWO',0,0,0,125.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2039,'LN_MAKE_IT_BREAK','/Levels/CR_make_it_break_it',0,'LP_CRANKY_TWO',0,0,0,80.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2040,'LN_FILL_IT_FIRST','/Levels/save_your_shot',0,'LP_CRANKY_THREE',0,0,1,45.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2041,'LN_WATER_WHEEL','/Levels/giant_wheel_JOSE',0,'LP_CRANKY_THREE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2042,'LN_WATERFALL','/Levels/waterfall2',0,'LP_CRANKY_THREE',0,0,0,55.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2043,'LN_CROSS_THE_LINE','/Levels/combinator',0,'LP_CRANKY_THREE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2044,'LN_CRANKY_BLAST','/Levels/Kblast',0,'LP_CRANKY_THREE',0,0,0,55.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2045,'LN_RAINCATCHER','/Levels/raincatcher',0,'LP_CRANKY_THREE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2046,'LN_EXPLOSIVE_COMBINATION','/Levels/one_drop',0,'LP_CRANKY_THREE',0,0,0,55.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2047,'LN_BOTTOM_FEEDER','/Levels/BottomFeeder',0,'LP_CRANKY_THREE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2048,'LN_GUSHER','/Levels/gusher',0,'LP_CRANKY_THREE',0,0,0,80.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2049,'LN_BLOCKED_SHOTS','/Levels/Interruptions',0,'LP_CRANKY_THREE',0,0,0,60.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2050,'LN_BOXED_IN','/Levels/boxes',0,'LP_CRANKY_THREE',0,0,0,80.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2051,'LN_BLOW_YOUR_TOP','/Levels/contained',0,'LP_CRANKY_THREE',0,0,0,55.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2052,'LN_DRIP_DROP_BAM','/Levels/drip_drop_bam',0,'LP_CRANKY_THREE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2053,'LN_UNLEASH_THE_OOZE','/Levels/circus_ooze_BHVR',0,'LP_CRANKY_THREE',0,0,0,55.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2054,'LN_LEAKY_FAUCET','/Levels/LeakySpoutOneScreen',0,'LP_CRANKY_THREE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2055,'LN_GRAVITY_PUSH','/Levels/gravity_work_for_me_TOM',0,'LP_CRANKY_THREE',0,0,0,55.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2056,'LN_CROSS_THE_STREAMS','/Levels/cross_the_streams',0,'LP_CRANKY_THREE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2057,'LN_WATER_DELIVERY_SERVICE','/Levels/convergence_points',0,'LP_CRANKY_THREE',0,0,0,60.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2058,'LN_PUMP_SYSTEM','/Levels/pump_system',0,'LP_CRANKY_THREE',0,0,0,100.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2059,'LN_STRAIGHT_AND_NARROW','/Levels/one_dimensional',0,'LP_CRANKY_THREE',0,0,0,70.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2060,'LN_CUT_FIRST','/Levels/01_CUT_FIRST',0,'LP_CRANKY_FOUR',0,0,1,30.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2061,'LN_DONT_BE_GREEDY','/Levels/02_DONT_BE_GREEDY',0,'LP_CRANKY_FOUR',0,0,0,40.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2062,'LN_CLEAR_PATH','/Levels/03_CLEAR_A_PATH',0,'LP_CRANKY_FOUR',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2063,'LN_ACID_RAIN','/Levels/04_ACID_RAIN',0,'LP_CRANKY_FOUR',0,0,0,40.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2064,'LN_HEROS_JOURNEY','/Levels/05_HEROS_JOURNEY',0,'LP_CRANKY_FOUR',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2065,'LN_POISON_POWER','/Levels/06_POISON_POWER',0,'LP_CRANKY_FOUR',0,0,0,60.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2066,'LN_WATER_CATCHER','/Levels/07_WATER_CATCHER',0,'LP_CRANKY_FOUR',0,0,0,60.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2067,'LN_CROSSING_PATHS_NAME','/Levels/08_CROSSING_PATHS',0,'LP_CRANKY_FOUR',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2068,'LN_HOT_AIR_TRIGGER','/Levels/09_HOT_AIR_TRIGGER',0,'LP_CRANKY_FOUR',0,0,0,60.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2069,'LN_MAKE_A_MOUNTAIN','/Levels/10_MAKE_A_MOUNTAIN',0,'LP_CRANKY_FOUR',0,0,0,70.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2070,'LN_OCCLUSION_JOURNEY','/Levels/11_WIND_SHIELD',0,'LP_CRANKY_FOUR',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2071,'LN_CLOSING_TIMER','/Levels/12_CLOSING_TIMER',0,'LP_CRANKY_FOUR',0,0,0,35.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2072,'LN_TEAR_DOWN_THE_WALLS','/Levels/13_TEAR_DOWN_THE_WALLS',0,'LP_CRANKY_FOUR',0,0,0,60.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2073,'LN_WIND_BUCKET','/Levels/14_WIND_BUCKET',0,'LP_CRANKY_FOUR',0,0,0,40.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2074,'LN_GAINING_GROUND','/Levels/15_GAINING_GROUND',0,'LP_CRANKY_FOUR',0,0,0,75.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2075,'LN_POISON_GAUNTLET','/Levels/16_POISON_GAUNTLET',0,'LP_CRANKY_FOUR',0,0,0,75.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2076,'LN_CHEMICAL_REACTIONS','/Levels/17_CHEMICAL_REACTIONS',0,'LP_CRANKY_FOUR',0,0,0,60.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2077,'LN_MASTER_MOLD','/Levels/18_MASTER_MOLD',0,'LP_CRANKY_FOUR',0,0,0,60.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2078,'LN_WHERES_MY_POISON','/Levels/19_WHERES_MY_POISON',0,'LP_CRANKY_FOUR',0,0,0,115.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2079,'LN_DOOMSDAY_CLOCK','/Levels/20_DOOMSDAY_CLOCK',0,'LP_CRANKY_FOUR',0,0,0,30.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(2500,'LN_BALANCE_OUT','/Levels/drop_it',0,'LP_BONUS_CRANKY',0,0,1,43.0,0,-1,0,0,0,1,NULL,NULL,0,1);
INSERT INTO "LevelInfo" VALUES(2501,'LN_TURKEY_LEG','/Levels/turkey_leg',0,'LP_BONUS_CRANKY',0,0,1,43.0,0,-1,0,0,0,1,NULL,NULL,0,1);
INSERT INTO "LevelInfo" VALUES(2502,'LN_POLKA_DOTS','/Levels/rising_tide',0,'LP_BONUS_CRANKY',0,0,1,43.0,0,-1,0,0,0,1,NULL,NULL,0,1);
INSERT INTO "LevelInfo" VALUES(2503,'LN_CONTAMINATION_MAZE','/Levels/convert_em',0,'LP_BONUS_CRANKY',0,0,1,43.0,0,-1,0,0,0,1,NULL,NULL,0,1);
INSERT INTO "LevelInfo" VALUES(2504,'LN_FOUR_SQUARE','/Levels/two_dimensional',0,'LP_BONUS_CRANKY',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,1);
INSERT INTO "LevelInfo" VALUES(2505,'LN_THE_LONG_BOMB','/Levels/long_bomb',0,'LP_BONUS_CRANKY',0,0,0,45.0,0,-1,0,0,0,1,NULL,NULL,0,1);
INSERT INTO "LevelInfo" VALUES(2506,'LN_HIDE_AND_SEEK','/Levels/B1_HIDE_AND_SEEK',0,'LP_BONUS_CRANKY',0,0,0,15.0,0,-1,0,0,0,1,NULL,NULL,0,1);
INSERT INTO "LevelInfo" VALUES(2507,'LN_HOLES_IN_THE_WALLS','/Levels/B2_fragile_walls',0,'LP_BONUS_CRANKY',0,0,0,15.0,0,-1,0,0,0,1,NULL,NULL,0,1);
INSERT INTO "LevelInfo" VALUES(3000,'LN_ALLEY_OOP','/Levels/alley_oop',0,'LP_CALENDAR_UNLOCK',0,0,1,40.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3001,'LN_KITCHEN_TIMER','/Levels/kitchen_timer',0,'LP_CALENDAR_UNLOCK',0,0,0,42.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3002,'LN_PARTICLE_ACCELERATOR','/Levels/particle_accelerator',0,'LP_CALENDAR_UNLOCK',0,0,0,35.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3003,'LN_LEAKY_ELEVATOR','/Levels/leaky_elevator',0,'LP_CALENDAR_UNLOCK',0,0,0,30.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3004,'LN_DOUBLE_DOOR','/Levels/double_door',0,'LP_CALENDAR_UNLOCK',0,0,0,54.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3005,'LN_CONTROLLED_BLAST','/Levels/too_much_water',0,'LP_CALENDAR_UNLOCK',0,0,0,70.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3006,'LN_OUT_OF_ORDER','/Levels/bank_job',0,'LP_CALENDAR_UNLOCK',0,0,0,60.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3007,'LN_CYCLICAL','/Levels/loop_around',0,'LP_CALENDAR_UNLOCK',0,0,0,40.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3008,'LN_BOMB_STICK','/Levels/bombstick',0,'LP_CALENDAR_UNLOCK',0,0,0,63.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3009,'LN_AROUND_THE_WORLD','/Levels/cut_cut_cut',0,'LP_CALENDAR_UNLOCK',0,0,0,45.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3010,'LN_I_HEART_YOU','/Levels/i_heart_you',0,'LP_HEARTS_AND_CRAFTS',0,0,1,55.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3011,'LN_SPLIT_STREAM','/Levels/split_stream',0,'LP_HEARTS_AND_CRAFTS',0,0,0,70.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3012,'LN_SHOOTS_SPIRALS','/Levels/Shoots_and_Spirals',0,'LP_HEARTS_AND_CRAFTS',0,0,0,65.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3013,'LN_DOWNPOUR','/Levels/downpour',0,'LP_HEARTS_AND_CRAFTS',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3014,'LN_MAZE_DOWN','/Levels/maze_down',0,'LP_HEARTS_AND_CRAFTS',0,0,0,130.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3015,'LN_SOMETHING','/Levels/Right_On_Track',0,'LP_HEARTS_AND_CRAFTS',0,0,0,90.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3016,'LN_ALL_GREEN_LIGHTS','/Levels/all_green_lights',0,'LP_HEARTS_AND_CRAFTS',0,0,0,90.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3017,'LN_STEADY_HAND','/Levels/sliders_2',0,'LP_HEARTS_AND_CRAFTS',0,0,0,60.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3018,'LN_ALGAE_RACE','/Levels/algae_race',0,'LP_HEARTS_AND_CRAFTS',0,0,0,40.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3019,'LN_WATER_ACROBATICS','/Levels/water_acrobatics',0,'LP_HEARTS_AND_CRAFTS',0,0,0,100.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3020,'LN_TOUCH_FOR_WATER','/Levels/02_TOUCH_FOR_WATER',0,'LP_DAYS_OF_SUMMER',0,0,1,50.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3021,'LN_LAST_IS_FIRST','/Levels/03_LAST_IS_FIRST',0,'LP_DAYS_OF_SUMMER',0,0,0,60.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3022,'LN_SLOOP_SCHOOL','/Levels/04_SLOOP_SCHOOL',0,'LP_DAYS_OF_SUMMER',0,0,0,75.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3023,'LN_DUAL_TOOLS','/Levels/06_DUAL_TOOLS',0,'LP_DAYS_OF_SUMMER',0,0,0,70.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3024,'LN_TRIGGER_PATH','/Levels/05_TRIGGER_PATH',0,'LP_DAYS_OF_SUMMER',0,0,0,44.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3025,'LN_SPAGHETTI_SPOUTS','/Levels/01_SPAGHETTI_SPOUTS',0,'LP_DAYS_OF_SUMMER',0,0,0,63.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3026,'LN_UPHILL_BATTLE','/Levels/08_PUSH_UPS',0,'LP_DAYS_OF_SUMMER',0,0,0,55.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3027,'LN_BLAST_TUBE','/Levels/07_BLAST_TUBE',0,'LP_DAYS_OF_SUMMER',0,0,0,45.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3028,'LN_AROUND_THE_ROCK','/Levels/09_AROUND_THE_ROCK',0,'LP_DAYS_OF_SUMMER',0,0,0,54.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3029,'LN_ZIG_ZAG','/Levels/10_ZIG_ZAG',0,'LP_DAYS_OF_SUMMER',0,0,0,61.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3030,'LN_BEFORE_THE_FLOOD','/Levels/11_BEFORE_THE_FLOOD',0,'LP_DAYS_OF_SUMMER',0,0,0,64.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3031,'LN_MASTER_SLOOPER','/Levels/12_MASTER_SLOOPER',0,'LP_DAYS_OF_SUMMER',0,0,0,66.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(3500,'LN_SPLIT_DOWN_THE_MIDDLE','/Levels/LN_SPLIT_DOWN_THE_MIDDLE',0,'LP_CALENDAR_UNLOCK',0,0,0,15.0,0,-1,0,0,1,1,NULL,NULL,1,1);
INSERT INTO "LevelInfo" VALUES(3501,'LN_CIRCULATORY_SYSTEM','/Levels/got_heart',0,'LP_HEARTS_AND_CRAFTS',0,0,0,15.0,0,-1,0,0,1,1,NULL,NULL,1,1);
INSERT INTO "LevelInfo" VALUES(3502,'LN_FOOTPRINT','/Levels/B1_FOOTPRINT',0,'LP_DAYS_OF_SUMMER',0,0,0,15.0,0,-1,0,0,1,1,NULL,NULL,1,1);
INSERT INTO "LevelInfo" VALUES(4000,'LN_FIRST_DIG','/Levels/first_dig',0,'LP_ONE_MYSTERY',0,0,1,20.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(4001,'LN_ROCK_HARD_PLACE','/Levels/rock_is_a_hard_place',0,'LP_ONE_MYSTERY',0,0,0,22.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(4002,'LN_YELLOW_BRICK_ROAD','/Levels/yellow_brick_road',0,'LP_ONE_MYSTERY',0,0,0,23.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(4003,'LN_JUMP_ON_IT','/Levels/jump_on_it',0,'LP_ONE_MYSTERY',0,0,0,19.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(4004,'LN_DONT_DILLY_DALLY','/Levels/itll_grow_on_you',0,'LP_ONE_MYSTERY',0,0,0,23.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(4005,'LN_DEEP_DIG','/Levels/deep_dig',0,'LP_ONE_MYSTERY',0,0,0,32.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4006,'LN_DRAIN_IT_FIRST','/Levels/drain_it_first',0,'LP_ONE_MYSTERY',0,0,0,33.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4007,'LN_DIRTY_WATER','/Levels/dirty_water_and_algae',0,'LP_ONE_MYSTERY',0,0,0,48.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4008,'LN_MAKE_MORE_DIRTY','/Levels/make_more_dirty_water',0,'LP_ONE_MYSTERY',0,0,0,43.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4009,'LN_SPLIT_DECISION','/Levels/split_decision_numero_dos',0,'LP_ONE_MYSTERY',0,0,0,63.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4010,'LN_DIVERT','/Levels/divert',0,'LP_ONE_MYSTERY',0,0,0,23.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4011,'LN_FIRST_SWITCH','/Levels/first_switch',0,'LP_ONE_MYSTERY',0,0,0,27.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4012,'LN_SWITCH_FALL','/Levels/switch_fall',0,'LP_ONE_MYSTERY',0,0,0,60.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4013,'LN_LOOP_THE_LOOP','/Levels/loop_redux',0,'LP_ONE_MYSTERY',0,0,0,58.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4014,'LN_MOTOR_TEST','/Levels/motor_test',0,'LP_ONE_MYSTERY',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4015,'LN_FLINGING_HORSESHOES','/Levels/flinging_horseshoes',0,'LP_ONE_MYSTERY',0,0,0,33.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4016,'LN_OFF_TRACK','/Levels/off_track',0,'LP_ONE_MYSTERY',0,0,0,32.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4017,'LN_SWITCH_OFF_GRASS','/Levels/switch_off_the_grass',0,'LP_ONE_MYSTERY',0,0,0,34.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4018,'LN_SEESAW','/Levels/seesaw',0,'LP_ONE_MYSTERY',0,0,0,31.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4019,'LN_TARRED_FEATHERED','/Levels/tarred_and_feathered',0,'LP_ONE_MYSTERY',0,0,0,33.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4020,'LN_TAKE_ME_HIGHER','/Levels/can_you_take_me_higher',0,'LP_TWO_MYSTERY',0,0,1,43.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4021,'LN_SMASH_THEM_TOGETHER','/Levels/smash_them_together',0,'LP_TWO_MYSTERY',0,0,0,20.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4022,'LN_INTO_THE_CAVE','/Levels/into_the_cave',0,'LP_TWO_MYSTERY',0,0,0,28.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4023,'LN_LONG_JOURNEY','/Levels/long_journey',0,'LP_TWO_MYSTERY',0,0,0,40.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4024,'LN_THERE_AND_BACK','/Levels/there_and_back_again',0,'LP_TWO_MYSTERY',0,0,0,40.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4025,'LN_HURRY','/Levels/hurry',0,'LP_TWO_MYSTERY',0,0,0,20.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4026,'LN_WHAT_GOES_UP','/Levels/what_goes_up',0,'LP_TWO_MYSTERY',0,0,0,23.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4027,'LN_ONE_STREAM','/Levels/one_stream',0,'LP_TWO_MYSTERY',0,0,0,40.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4028,'LN_ONE_STEP_AT_TIME','/Levels/one_step_at_a_time',0,'LP_TWO_MYSTERY',0,0,0,36.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4029,'LN_MAKE_WAVE','/Levels/make_a_wave',0,'LP_TWO_MYSTERY',0,0,0,36.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4030,'LN_REPTILES_PLUMBERS','/Levels/reptiles_and_plumbers',0,'LP_TWO_MYSTERY',0,0,0,28.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4031,'LN_BUNKER','/Levels/bunker',0,'LP_TWO_MYSTERY',0,0,0,25.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4032,'LN_LEVEL_IT_OUT','/Levels/level_it_out',0,'LP_TWO_MYSTERY',0,0,0,35.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4033,'LN_MIND_THE_GAP','/Levels/mind_the_gap',0,'LP_TWO_MYSTERY',0,0,0,55.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4034,'LN_DANTES_WIDOWS_PEAK','/Levels/dantes_widows_peak',0,'LP_TWO_MYSTERY',0,0,0,35.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4035,'LN_CATCH_IF_YOU_CAN','/Levels/catch_me_if_you_can',0,'LP_TWO_MYSTERY',0,0,0,48.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4036,'LN_CONVERSION','/Levels/conversion',0,'LP_TWO_MYSTERY',0,0,0,53.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4037,'LN_SLUDGE_THE_DESTROYER','/Levels/sludge_the_destroyer',0,'LP_TWO_MYSTERY',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4038,'LN_ORBIT','/Levels/orbit',0,'LP_TWO_MYSTERY',0,0,0,49.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4039,'LN_HALF_HALF','/Levels/half_and_half',0,'LP_TWO_MYSTERY',0,0,0,66.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4040,'LN_MINE_FIELD','/Levels/mine_field',0,'LP_THREE_MYSTERY',0,0,1,40.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4041,'LN_AROUND_THE_BOMB','/Levels/around_the_bomb',0,'LP_THREE_MYSTERY',0,0,0,32.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4042,'LN_LAVA_TIMING','/Levels/lava_timing',0,'LP_THREE_MYSTERY',0,0,0,38.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4043,'LN_MULTITOUCH','/Levels/multitouch',0,'LP_THREE_MYSTERY',0,0,0,33.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4044,'LN_BOMB_CHAIN','/Levels/bomb_chain',0,'LP_THREE_MYSTERY',0,0,0,28.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4045,'LN_CROSSING_RIVER','/Levels/crossing_the_river',0,'LP_THREE_MYSTERY',0,0,0,100.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4046,'LN_FROM_ON_HIGH','/Levels/from_on_high',0,'LP_THREE_MYSTERY',0,0,0,33.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4047,'LN_LETS_PLAY_CATCH','/Levels/lets_play_catch',0,'LP_THREE_MYSTERY',0,0,0,53.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4048,'LN_FIRST_MOMENTARY','/Levels/first_momentary',0,'LP_THREE_MYSTERY',0,0,0,49.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4049,'LN_LAVA_RIVER','/Levels/lava_river',0,'LP_THREE_MYSTERY',0,0,0,37.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4050,'LN_RAT_IN_A_MAZE','/Levels/rat_in_a_maze',0,'LP_THREE_MYSTERY',0,0,0,90.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4051,'LN_BOMB_IT_UP','/Levels/bomb_it_up',0,'LP_THREE_MYSTERY',0,0,0,69.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4052,'LN_REDIRECTION','/Levels/redirection',0,'LP_THREE_MYSTERY',0,0,0,63.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4053,'LN_BLOW_THE_ROOF_OFF','/Levels/blow_the_roof_off',0,'LP_THREE_MYSTERY',0,0,0,45.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4054,'LN_GOING_DOWN','/Levels/going_down',0,'LP_THREE_MYSTERY',0,0,0,58.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4055,'LN_TEMPLE_TACTICS','/Levels/temple_tactics',0,'LP_THREE_MYSTERY',0,0,0,63.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4056,'LN_EROSION','/Levels/erosion',0,'LP_THREE_MYSTERY',0,0,0,63.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4057,'LN_UNTIMELY_GROWTH','/Levels/untimely_growth',0,'LP_THREE_MYSTERY',0,0,0,41.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4058,'LN_WATER_PINBALL','/Levels/water_pinball',0,'LP_THREE_MYSTERY',0,0,0,39.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4059,'LN_AQUA_PORTALS','/Levels/aqua_portals',0,'LP_THREE_MYSTERY',0,0,0,68.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4060,'LN_LOGIC_GATES','/Levels/logic_gates',0,'LP_FOUR_MYSTERY',0,0,1,32.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4061,'LN_MOMENTUM_101','/Levels/momentum_101',0,'LP_FOUR_MYSTERY',0,0,0,29.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4062,'LN_PIPING','/Levels/piping',0,'LP_FOUR_MYSTERY',0,0,0,56.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4063,'LN_BRIDGE_BUILDER','/Levels/bridge_builder',0,'LP_FOUR_MYSTERY',0,0,0,65.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4064,'LN_FLING_SHOT','/Levels/fling_shot',0,'LP_FOUR_MYSTERY',0,0,0,70.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4065,'LN_DADDY_WATERBUCKS','/Levels/daddy_waterbucks',0,'LP_FOUR_MYSTERY',0,0,0,46.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4066,'LN_SQUEEZE_MY_WATER','/Levels/squeeze_my_water',0,'LP_FOUR_MYSTERY',0,0,0,80.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4067,'LN_NICE_CLOGS','/Levels/nice_clogs',0,'LP_FOUR_MYSTERY',0,0,0,40.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4068,'LN_CURSE_OF_THE_ALGAE','/Levels/curse_of_the_algae_beard',0,'LP_FOUR_MYSTERY',0,0,0,46.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4069,'LN_SLIDERS','/Levels/sliders',0,'LP_FOUR_MYSTERY',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4070,'LN_THEYVE_GOT_CHEMISTRY','/Levels/theyve_got_chemistry',0,'LP_FOUR_MYSTERY',0,0,0,40.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4071,'LN_MODE_B','/Levels/if_you_build_it_they_will_come',0,'LP_FOUR_MYSTERY',0,0,0,60.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4072,'LN_DEATH_BLOSSOM','/Levels/death_blossom',0,'LP_FOUR_MYSTERY',0,0,0,57.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4073,'LN_RHYTHM_NIRVANA','/Levels/rhythm_nirvana',0,'LP_FOUR_MYSTERY',0,0,0,100.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4074,'LN_FIGURE_EIGHT','/Levels/figure_8',0,'LP_FOUR_MYSTERY',0,0,0,55.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4075,'LN_CREATE_DESTROY','/Levels/force_field',0,'LP_FOUR_MYSTERY',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4076,'LN_THE_GRID','/Levels/the_grid',0,'LP_FOUR_MYSTERY',0,0,0,55.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4077,'LN_ANOTHER_CASTLE','/Levels/another_castle',0,'LP_FOUR_MYSTERY',0,0,0,42.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4078,'LN_DANGEROUS_SLOPE','/Levels/dangerous_slope',0,'LP_FOUR_MYSTERY',0,0,0,100.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4079,'LN_RINSE_CYCLE','/Levels/rinse_cycle',0,'LP_FOUR_MYSTERY',0,0,0,140.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4101,'LN_CONVERTER_INTRO','/Levels/converter_intro',0,'LP_FIVE_MYSTERY',0,0,1,30.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4102,'LN_RECYCLING_WORKS','/Levels/recycling_works',0,'LP_FIVE_MYSTERY',0,0,0,35.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4103,'LN_OUCH_MY_EYE','/Levels/ouch_my_eye',0,'LP_FIVE_MYSTERY',0,0,0,35.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4104,'LN_CONVERSION_TEST','/Levels/test_tube_redux',0,'LP_FIVE_MYSTERY',0,0,0,45.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4105,'LN_CONVERTER_JOURNEY','/Levels/converter_journey',0,'LP_FIVE_MYSTERY',0,0,0,40.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4106,'LN_CLEAR_AND_SHOOT','/Levels/clear_and_shoot',0,'LP_FIVE_MYSTERY',0,0,0,55.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4107,'LN_DOUBLE_LAUNCH_REDUX','/Levels/double_launch_redux',0,'LP_FIVE_MYSTERY',0,0,0,45.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4108,'LN_UNDERCURRENT','/Levels/undercurrent',0,'LP_FIVE_MYSTERY',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4109,'LN_MULTI_CONVERT','/Levels/multi_convert',0,'LP_FIVE_MYSTERY',0,0,0,40.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4110,'LN_MINER','/Levels/miner',0,'LP_FIVE_MYSTERY',0,0,0,70.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4111,'LN_CATCH_THEM_ALL','/Levels/catch_them_all',0,'LP_FIVE_MYSTERY',0,0,0,45.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4112,'LN_SCAFFOLDING','/Levels/scaffolding',0,'LP_FIVE_MYSTERY',0,0,0,35.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4113,'LN_GET_ON_THE_TRAIN','/Levels/get_on_the_train',0,'LP_FIVE_MYSTERY',0,0,0,55.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4114,'LN_DOUBLE_DIPPING','/Levels/double_dipping',0,'LP_FIVE_MYSTERY',0,0,0,45.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4115,'LN_CONVERTER_GATE','/Levels/converter_gate',0,'LP_FIVE_MYSTERY',0,0,0,60.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4116,'LN_OOZE_IS_ALRIGHT','/Levels/ooze_is_alright',0,'LP_FIVE_MYSTERY',0,0,0,35.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4117,'LN_PICK_YOUR_POISON','/Levels/pick_your_poison',0,'LP_FIVE_MYSTERY',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4118,'LN_ACROSS_THE_BRIDGE','/Levels/across_the_bridge',0,'LP_FIVE_MYSTERY',0,0,0,60.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4119,'LN_THE_POT_BOILS_OVER','/Levels/the_pot_boils_over',0,'LP_FIVE_MYSTERY',0,0,0,45.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4120,'LN_HOOKSHOT_HEAVEN','/Levels/hookshot_heaven',0,'LP_FIVE_MYSTERY',0,0,0,60.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4121,'LN_STEAM_INTRO','/Levels/steam_intro',0,'LP_SIX_MYSTERY',0,0,1,25.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4122,'LN_RECYCLER','/Levels/recycler',0,'LP_SIX_MYSTERY',0,0,0,40.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4123,'LN_CEILING_CATCHER','/Levels/ceiling_catcher',0,'LP_SIX_MYSTERY',0,0,0,40.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4124,'LN_RISE_AND_FALL','/Levels/rise_and_fall',0,'LP_SIX_MYSTERY',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4125,'LN_A_CLEANER_APPROACH','/Levels/a_cleaner_approach',0,'LP_SIX_MYSTERY',0,0,0,55.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4126,'LN_CATCH_AND_RELEASE','/Levels/catch_and_release',0,'LP_SIX_MYSTERY',0,0,0,75.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4127,'LN_SEPARATE_WAYS','/Levels/separate_ways',0,'LP_SIX_MYSTERY',0,0,0,80.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4128,'LN_THROUGH_THE_BRIDGE','/Levels/through_the_bridge',0,'LP_SIX_MYSTERY',0,0,0,45.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4129,'LN_OL_SWITCHEROO','/Levels/ol_switcheroo',0,'LP_SIX_MYSTERY',0,0,0,55.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4130,'LN_BELOW_THE_BBQ','/Levels/below_the_bbq',0,'LP_SIX_MYSTERY',0,0,0,40.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4131,'LN_A_RACE_TO_THE_FINISH','/Levels/a_race_to_the_finish',0,'LP_SIX_MYSTERY',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4132,'LN_REVOLVING_DOOR','/Levels/revolving_door',0,'LP_SIX_MYSTERY',0,0,0,55.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4133,'LN_RACE_THE_OOZE','/Levels/race_the_ooze',0,'LP_SIX_MYSTERY',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4134,'LN_STEAM_BOT','/Levels/steam_bot',0,'LP_SIX_MYSTERY',0,0,0,75.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4135,'LN_VENTILATION_SHAFT','/Levels/ventilation_shaft',0,'LP_SIX_MYSTERY',0,0,0,55.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4136,'LN_STEAM_QUARANTENE','/Levels/steam_quarantene',0,'LP_SIX_MYSTERY',0,0,0,45.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4137,'LN_JUMPING_GIGAWATTS','/Levels/jumping_gigawatts',0,'LP_SIX_MYSTERY',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4138,'LN_TRAP_DOOR','/Levels/trap_door',0,'LP_SIX_MYSTERY',0,0,0,45.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4139,'LN_UP_AND_DOWN','/Levels/up_and_down',0,'LP_SIX_MYSTERY',0,0,0,65.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4140,'LN_STEAM_JOURNEY','/Levels/time_to_split',0,'LP_SIX_MYSTERY',0,0,0,120.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4141,'LN_BALLOON_INTRO','/Levels/balloon_intro',0,'LP_SEVEN_MYSTERY',0,0,1,35.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4142,'LN_BURST_YOUR_BUBBLE','/Levels/2_pop',0,'LP_SEVEN_MYSTERY',0,0,0,40.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4143,'LN_GEYSER','/Levels/geiser',0,'LP_SEVEN_MYSTERY',0,0,0,39.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4144,'LN_BALLOON_BRIDGE','/Levels/balloon_bridge',0,'LP_SEVEN_MYSTERY',0,0,0,38.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4145,'LN_JAGGED_EDGE','/Levels/jagged_edge',0,'LP_SEVEN_MYSTERY',0,0,0,43.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4146,'LN_YOU_SHALL_NOT_PASS','/Levels/you_shall_not_pass',0,'LP_SEVEN_MYSTERY',0,0,0,43.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4147,'LN_TRUST_FALL','/Levels/firin_mah_lazer',0,'LP_SEVEN_MYSTERY',0,0,0,44.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4148,'LN_DROP_BY_DROP','/Levels/drop_by_drop',0,'LP_SEVEN_MYSTERY',0,0,0,41.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4149,'LN_BALLOON_CATAPULT','/Levels/balloon_catapult',0,'LP_SEVEN_MYSTERY',0,0,0,49.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4150,'LN_MIRROR_IMAGE','/Levels/mirror_image',0,'LP_SEVEN_MYSTERY',0,0,0,38.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4151,'LN_DRAIN_AND_DROP','/Levels/drain_and_drop',0,'LP_SEVEN_MYSTERY',0,0,0,45.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4152,'LN_HOT_AIR_BALLOON','/Levels/hot_air_balloon',0,'LP_SEVEN_MYSTERY',0,0,0,40.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4153,'LN_PINBALL','/Levels/balloon_pinball',0,'LP_SEVEN_MYSTERY',0,0,0,60.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4154,'LN_BALLOON_FOUNTAIN','/Levels/balloon_fountain',0,'LP_SEVEN_MYSTERY',0,0,0,55.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4155,'LN_BALLOON_JOURNEY','/Levels/current_pool',0,'LP_SEVEN_MYSTERY',0,0,0,53.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4156,'LN_PURER_PATHS_PREVAIL','/Levels/purer_paths_prevail',0,'LP_SEVEN_MYSTERY',0,0,0,43.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4157,'LN_PLATFORMER','/Levels/new_platformer',0,'LP_SEVEN_MYSTERY',0,0,0,57.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4158,'LN_BOOBY_TRAP_STAIRCASE','/Levels/booby_trap_staircase',0,'LP_SEVEN_MYSTERY',0,0,0,71.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4159,'LN_PUSH_POP','/Levels/push_pop',0,'LP_SEVEN_MYSTERY',0,0,0,51.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4160,'LN_ROLL_YOUR_OWN_POISON','/Levels/roll_your_own_poison',0,'LP_SEVEN_MYSTERY',0,0,0,75.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4161,'LN_FIRST_FAN','/Levels/first_fan',0,'LP_EIGHT_MYSTERY',0,0,1,25.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4162,'LN_FAN_INTRO','/Levels/fan_intro',0,'LP_EIGHT_MYSTERY',0,0,0,30.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4163,'LN_UPDRAFT','/Levels/updraft',0,'LP_EIGHT_MYSTERY',0,0,0,30.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4164,'LN_OVERLAP','/Levels/overlap',0,'LP_EIGHT_MYSTERY',0,0,0,40.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4165,'LN_ON_AND_OFF','/Levels/on_and_off',0,'LP_EIGHT_MYSTERY',0,0,0,35.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4166,'LN_VACUUM_TUTORIAL','/Levels/Vacuum_Tutorial',0,'LP_EIGHT_MYSTERY',0,0,0,40.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4167,'LN_VOID','/Levels/void',0,'LP_EIGHT_MYSTERY',0,0,0,40.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4168,'LN_PULL_UP','/Levels/dirty_fan',0,'LP_EIGHT_MYSTERY',0,0,0,40.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4169,'LN_OCCULSION_TUTORIAL','/Levels/occlude_tutorial',0,'LP_EIGHT_MYSTERY',0,0,0,30.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4170,'LN_MAKE_UP_YOUR_MIND','/Levels/flip_flop',0,'LP_EIGHT_MYSTERY',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4171,'LN_FREEFALLIN','/Levels/freefallin',0,'LP_EIGHT_MYSTERY',0,0,0,35.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4172,'LN_VACUUM_BRIDGE','/Levels/Vacuum_Bridge',0,'LP_EIGHT_MYSTERY',0,0,0,70.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4173,'LN_ALL_YOUR_DUCKS','/Levels/fan_divert',0,'LP_EIGHT_MYSTERY',0,0,0,60.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4174,'LN_ICE_PIT','/Levels/ice_pit',0,'LP_EIGHT_MYSTERY',0,0,0,90.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4175,'LN_WATER_WORLD','/Levels/waterworld',0,'LP_EIGHT_MYSTERY',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4176,'LN_PULL_ME_UP','/Levels/pass_the_balloon',0,'LP_EIGHT_MYSTERY',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4177,'LN_EVIL_FAN','/Levels/evil_fan',0,'LP_EIGHT_MYSTERY',0,0,0,70.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4178,'LN_FAN_CLEANER','/Levels/mid_air_mix',0,'LP_EIGHT_MYSTERY',0,0,0,40.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4179,'LN_WIND_SLOOPER','/Levels/wind_slooper',0,'LP_EIGHT_MYSTERY',0,0,0,55.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4180,'LN_GRAVITY_DYNAMO','/Levels/gravity_dynamo',0,'LP_EIGHT_MYSTERY',0,0,0,100.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4181,'LN_CHANGE_DIRECTION','/Levels/change_directions',0,'LP_NINE_MYSTERY',0,0,1,35.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4182,'LN_MIX_IT_UP','/Levels/hydrospheres',0,'LP_NINE_MYSTERY',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4183,'LN_ALTERNATING_CURRENTS','/Levels/switch_it_up',0,'LP_NINE_MYSTERY',0,0,0,75.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4184,'LN_ONE_SHOT_WONDER','/Levels/one_in_the_barrel',0,'LP_NINE_MYSTERY',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4185,'LN_CONJUNCTION_JUNCTION','/Levels/FlippingSwitches',0,'LP_NINE_MYSTERY',0,0,0,70.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4186,'LN_HALF_AND_HALF_TWO','/Levels/spread_the_wealth',0,'LP_NINE_MYSTERY',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4187,'LN_CROSSING_GUARD','/Levels/pass_the_peas',0,'LP_NINE_MYSTERY',0,0,0,60.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4188,'LN_STOPPED_UP','/Levels/stoppit',0,'LP_NINE_MYSTERY',0,0,0,45.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4189,'LN_STOP_AND_DROP','/Levels/plop',0,'LP_NINE_MYSTERY',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4190,'LN_KEEP_IT_UP','/Levels/keep_it_up',0,'LP_NINE_MYSTERY',0,0,0,60.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4191,'LN_RAINMAKER','/Levels/rainmaker',0,'LP_NINE_MYSTERY',0,0,0,55.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4192,'LN_HALF_EMPTY','/Levels/flooded_shooting',0,'LP_NINE_MYSTERY',0,0,0,60.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4193,'LN_OCTOSPOUT','/Levels/octospout',0,'LP_NINE_MYSTERY',0,0,0,75.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4194,'LN_EXPLODING_ELEVATOR','/Levels/all_is_needed',0,'LP_NINE_MYSTERY',0,0,0,75.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4195,'LN_TRI_CYCLE','/Levels/controlled_thought-JOSE',0,'LP_NINE_MYSTERY',0,0,0,100.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4196,'LN_STEAM_SPLITTER','/Levels/steam_splitter',0,'LP_NINE_MYSTERY',0,0,0,70.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4197,'LN_OOZEPOCALYPSE','/Levels/oozepocalypse2012',0,'LP_NINE_MYSTERY',0,0,0,30.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4198,'LN_LEVITATING_LIQUIDS','/Levels/juggling',0,'LP_NINE_MYSTERY',0,0,0,90.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4199,'LN_OOZE_IT_OR_LOSE_IT','/Levels/need_all_of_it',0,'LP_NINE_MYSTERY',0,0,0,70.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4200,'LN_FULL_OF_HOT_AIR','/Levels/valve_playground',0,'LP_NINE_MYSTERY',0,0,0,180.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4201,'LN_FIRST_MUD_ALSO','/Levels/01_let_it_dry',0,'LP_TEN_MYSTERY',0,0,1,40.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4202,'LN_WALL_AND_ALGAE','/Levels/02_muddy_floor',0,'LP_TEN_MYSTERY',0,0,0,45.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4203,'LN_DRY_ME','/Levels/03_cut_and_dry',0,'LP_TEN_MYSTERY',0,0,0,55.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4204,'LN_WALL_ON_THE_SPOT','/Levels/04_plug_the_hole',0,'LP_TEN_MYSTERY',0,0,0,45.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4205,'LN_SLOW_IT_DOWN','/Levels/05_bog_it_down',0,'LP_TEN_MYSTERY',0,0,0,40.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4206,'LN_MUDDY_JOURNEY','/Levels/06_muddy_journey',0,'LP_TEN_MYSTERY',0,0,0,60.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4207,'LN_ODDWALLS','/Levels/07_spots_on_the_wall',0,'LP_TEN_MYSTERY',0,0,0,75.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4208,'LN_CAN_YOU_DIG_IT','/Levels/08_can_you_dig_it',0,'LP_TEN_MYSTERY',0,0,0,85.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4209,'LN_DOUBLE_DECKER_BRIDGE','/Levels/09_double_decker_bridge',0,'LP_TEN_MYSTERY',0,0,0,55.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4210,'LN_DRAINCLOG','/Levels/10_walls_of_mud',0,'LP_TEN_MYSTERY',0,0,0,45.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4211,'LN_MUD_TOWERS','/Levels/11_mud_bucket',0,'LP_TEN_MYSTERY',0,0,0,75.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4212,'LN_SLOOP_DU_JOUR','/Levels/12_make_a_ramp',0,'LP_TEN_MYSTERY',0,0,0,75.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4213,'LN_WET_DRY','/Levels/13_subdivision',0,'LP_TEN_MYSTERY',0,0,0,70.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4214,'LN_READY_POSITION','/Levels/14_misty_mud',0,'LP_TEN_MYSTERY',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4215,'LN_MUD_SLOOP','/Levels/15_redo',0,'LP_TEN_MYSTERY',0,0,0,65.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4216,'LN_FILL_THE_COLUMS','/Levels/16_fill_columns',0,'LP_TEN_MYSTERY',0,0,0,100.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4217,'LN_LANDFILL','/Levels/17_landfill',0,'LP_TEN_MYSTERY',0,0,0,110.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4218,'LN_MUD_BOX','/Levels/18_bucket_builder',0,'LP_TEN_MYSTERY',0,0,0,100.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4219,'LN_SPA_TREATMENT','/Levels/19_spa_treatment',0,'LP_TEN_MYSTERY',0,0,0,70.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4220,'LN_MUD_BRIDGE','/Levels/20_dry_landing',0,'LP_TEN_MYSTERY',0,0,0,60.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(4221,'LN_STRAIGHT_SHOT','/Levels/LOW_Cranky',0,'LP_CRANKY_LOTW',0,0,1,43.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(4222,'LN_SWEAT_STUFF','/Levels/LOW_Mystery',0,'LP_MYSTERY_LOTW',0,0,1,50.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(4223,'LN_SWEAT_STUFF','/Levels/LOW_Swampy',0,'LP_SWAMPY_LOTW',0,0,1,50.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(5000,'LN_FEELING_STEAMY','/Levels/allie1lev01_feeling_steamy',0,'LP_ALLIE_ONE',0,0,1,50.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(5001,'LN_CROSSING_STEAMS','/Levels/allie1lev02_crossing_steams',0,'LP_ALLIE_ONE',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(5002,'LN_CROSSROADS','/Levels/allie1lev03_crossroads',0,'LP_ALLIE_ONE',0,0,0,50.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(5003,'LN_FIRE_THE_FURNACE','/Levels/allie1lev04_fire_the_furnace',0,'LP_ALLIE_ONE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(5004,'LN_BURNING_HOT_COALS','/Levels/allie1lev05_burning_hot_coala',0,'LP_ALLIE_ONE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(5005,'LN_ICE_TO_STEAM_YOU','/Levels/allie1lev06_ice_to_steam_you',0,'LP_ALLIE_ONE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5006,'LN_CHIMNEY','/Levels/allie1lev07_chimney',0,'LP_ALLIE_ONE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5007,'LN_ICING_DOWN','/Levels/allie1lev08_icing_down',0,'LP_ALLIE_ONE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5008,'LN_FAN_WITH_A_PLAN','/Levels/allie1lev09_fan_with_a_plan',0,'LP_ALLIE_ONE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5009,'LN_STEAM_GUIDANCE','/Levels/allie1lev10_steam_guidance',0,'LP_ALLIE_ONE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5010,'LN_FAN_FORCED','/Levels/allie1lev11_fan_forced',0,'LP_ALLIE_ONE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5011,'LN_WATERFALL','/Levels/allie1lev12_waterfall',0,'LP_ALLIE_ONE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5012,'LN_ICE_CAVERN','/Levels/allie1lev13_ice_cavern',0,'LP_ALLIE_ONE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5013,'LN_A_TOUCH_OF_STEAM','/Levels/allie1lev14_a_touch_of_steam',0,'LP_ALLIE_ONE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5014,'LN_BBQ_GRILL','/Levels/allie1lev15_bbq_grill',0,'LP_ALLIE_ONE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5015,'LN_TOTAL_CONVERSION','/Levels/allie1lev16_total_conversion',0,'LP_ALLIE_ONE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5016,'LN_ICE_CLUSTERS','/Levels/allie1lev17_ice_clusters',0,'LP_ALLIE_ONE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5017,'LN_ALL_TOGETHER_NOW','/Levels/allie1lev18_all_together_now',0,'LP_ALLIE_ONE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5018,'LN_FAN_TASTIC','/Levels/allie1lev19_fan_tastic',0,'LP_ALLIE_ONE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5019,'LN_STEAM_BLAST','/Levels/allie1lev20_steam_blast',0,'LP_ALLIE_ONE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5020,'LN_WHERES_MY_STEAM','/Levels/allie2lev01_wheres_my_steam',0,'LP_ALLIE_TWO',0,0,1,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5021,'LN_PURIFICATION','/Levels/allie2lev02_purification',0,'LP_ALLIE_TWO',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5022,'LN_TUNNEL_OF_STEAM','/Levels/allie2lev03_tunnel_of_steam',0,'LP_ALLIE_TWO',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5023,'LN_STEAMY_BOW','/Levels/allie2lev04_steamy_dodger',0,'LP_ALLIE_TWO',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5024,'LN_SLIDE_PUZZLE','/Levels/allie2lev05_slide_puzzle',0,'LP_ALLIE_TWO',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5025,'LN_CONNECT_EM_UP','/Levels/allie2lev06_connect_em_up',0,'LP_ALLIE_TWO',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5026,'LN_CLEARING_THE_WAY','/Levels/allie2lev07_clearing_the_way',0,'LP_ALLIE_TWO',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5027,'LN_SWITCH_AND_MOVE','/Levels/allie2lev08_switch_and_move',0,'LP_ALLIE_TWO',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5028,'LN_LOUVRES','/Levels/allie2lev09_louvres',0,'LP_ALLIE_TWO',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5029,'LN_STEAM_TREE','/Levels/allie2lev10_steam_tree',0,'LP_ALLIE_TWO',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5030,'LN_ORDER_UP','/Levels/allie2lev11_order_up',0,'LP_ALLIE_TWO',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5031,'LN_SPOUTING_OFF','/Levels/allie2lev12_spouting_off',0,'LP_ALLIE_TWO',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5032,'LN_HYDRAULIC_LIFT','/Levels/allie2lev13_hydraulic_lift',0,'LP_ALLIE_TWO',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5033,'LN_WET_FLOOR','/Levels/allie2lev14_wet_floor',0,'LP_ALLIE_TWO',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5034,'LN_WATER_CYCLE','/Levels/allie2lev15_water_cycle',0,'LP_ALLIE_TWO',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5035,'LN_GROWING_PROTECTION','/Levels/allie2lev16_growing_protection',0,'LP_ALLIE_TWO',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5036,'LN_INLET','/Levels/allie2lev17_inlet',0,'LP_ALLIE_TWO',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5037,'LN_PORTCULLIS','/Levels/allie2lev18_portcullis',0,'LP_ALLIE_TWO',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5038,'LN_PUNDULUM','/Levels/allie2lev19_pendulum',0,'LP_ALLIE_TWO',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5039,'LN_STEAM_AND_CROSSES','/Levels/allie2lev20_steam_and_crosses',0,'LP_ALLIE_TWO',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5040,'LN_ALLIE_TEST_41','/Levels/AllieTest',0,'LP_ALLIE_THREE',0,0,1,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5041,'LN_ALLIE_TEST_42','/Levels/AllieTest',0,'LP_ALLIE_THREE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5042,'LN_ALLIE_TEST_43','/Levels/AllieTest2',0,'LP_ALLIE_THREE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5043,'LN_ALLIE_TEST_44','/Levels/AllieTest3',0,'LP_ALLIE_THREE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5044,'LN_ALLIE_TEST_45','/Levels/AllieTest4',0,'LP_ALLIE_THREE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5045,'LN_ALLIE_TEST_46','/Levels/AllieTest5',0,'LP_ALLIE_THREE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5046,'LN_ALLIE_TEST_47','/Levels/AllieTest6',0,'LP_ALLIE_THREE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5047,'LN_ALLIE_TEST_48','/Levels/AllieTest7',0,'LP_ALLIE_THREE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5048,'LN_ALLIE_TEST_49','/Levels/AllieTest7',0,'LP_ALLIE_THREE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5049,'LN_ALLIE_TEST_50','/Levels/AllieTest7',0,'LP_ALLIE_THREE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5050,'LN_ALLIE_TEST_51','/Levels/AllieTest7',0,'LP_ALLIE_THREE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5051,'LN_ALLIE_TEST_52','/Levels/AllieTest7',0,'LP_ALLIE_THREE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5052,'LN_ALLIE_TEST_53','/Levels/AllieTest7',0,'LP_ALLIE_THREE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5053,'LN_ALLIE_TEST_54','/Levels/AllieTest7',0,'LP_ALLIE_THREE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5054,'LN_ALLIE_TEST_55','/Levels/AllieTest7',0,'LP_ALLIE_THREE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5055,'LN_ALLIE_TEST_56','/Levels/AllieTest7',0,'LP_ALLIE_THREE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5056,'LN_ALLIE_TEST_57','/Levels/AllieTest7',0,'LP_ALLIE_THREE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5057,'LN_ALLIE_TEST_58','/Levels/AllieTest7',0,'LP_ALLIE_THREE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5058,'LN_ALLIE_TEST_59','/Levels/AllieTest7',0,'LP_ALLIE_THREE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5059,'LN_ALLIE_TEST_60','/Levels/AllieTest7',0,'LP_ALLIE_THREE',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5060,'LN_ALLIE_TEST_61','/Levels/AllieTest',0,'LP_ALLIE_FOUR',0,0,1,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5061,'LN_ALLIE_TEST_62','/Levels/AllieTest',0,'LP_ALLIE_FOUR',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5062,'LN_ALLIE_TEST_63','/Levels/AllieTest2',0,'LP_ALLIE_FOUR',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5063,'LN_ALLIE_TEST_64','/Levels/AllieTest3',0,'LP_ALLIE_FOUR',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5064,'LN_ALLIE_TEST_65','/Levels/AllieTest4',0,'LP_ALLIE_FOUR',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5065,'LN_ALLIE_TEST_66','/Levels/AllieTest5',0,'LP_ALLIE_FOUR',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5066,'LN_ALLIE_TEST_67','/Levels/AllieTest6',0,'LP_ALLIE_FOUR',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5067,'LN_ALLIE_TEST_68','/Levels/AllieTest7',0,'LP_ALLIE_FOUR',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5068,'LN_ALLIE_TEST_69','/Levels/AllieTest7',0,'LP_ALLIE_FOUR',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5069,'LN_ALLIE_TEST_70','/Levels/AllieTest7',0,'LP_ALLIE_FOUR',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5070,'LN_ALLIE_TEST_71','/Levels/AllieTest7',0,'LP_ALLIE_FOUR',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5071,'LN_ALLIE_TEST_72','/Levels/AllieTest7',0,'LP_ALLIE_FOUR',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5072,'LN_ALLIE_TEST_73','/Levels/AllieTest7',0,'LP_ALLIE_FOUR',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5073,'LN_ALLIE_TEST_74','/Levels/AllieTest7',0,'LP_ALLIE_FOUR',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5074,'LN_ALLIE_TEST_75','/Levels/AllieTest7',0,'LP_ALLIE_FOUR',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5075,'LN_ALLIE_TEST_76','/Levels/AllieTest7',0,'LP_ALLIE_FOUR',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5076,'LN_ALLIE_TEST_77','/Levels/AllieTest7',0,'LP_ALLIE_FOUR',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5077,'LN_ALLIE_TEST_78','/Levels/AllieTest7',0,'LP_ALLIE_FOUR',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5078,'LN_ALLIE_TEST_79','/Levels/AllieTest7',0,'LP_ALLIE_FOUR',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5079,'LN_ALLIE_TEST_80','/Levels/AllieTest7',0,'LP_ALLIE_FOUR',0,0,0,50.0,0,-1,0,0,0,1,NULL,NULL,0,0);
INSERT INTO "LevelInfo" VALUES(5080,'LN_ALLIE_LOTW_TEST','/Levels/LOW_Allie',0,'LP_ALLIE_LOTW',0,0,1,66.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(5081,'LN_FEATURED_TEST','/Levels/Featured1',0,'LP_FEATURED',0,0,1,66.0,0,-1,0,0,0,0,NULL,NULL,1,0);
INSERT INTO "LevelInfo" VALUES(5500,'LN_CHECKERBOARD','/Levels/allie_bonus_checkerboard',0,'LP_BONUS_ALLIE',0,0,0,15.0,0,-1,0,0,0,1,NULL,NULL,0,1);
INSERT INTO "LevelInfo" VALUES(5501,'LN_LEFT_BRAIN_RIGHT_BRAIN','/Levels/allie_bonus_left_brain_right_brain',0,'LP_BONUS_ALLIE',0,0,0,15.0,0,-1,0,0,0,1,NULL,NULL,0,1);
